@extends('auth.layout')
@section('title')    {{__(config('app.name'))}}
@endsection
@section('content')
    @push('css')
    @endpush

    <div class="wrapper">
        <div class="section-authentication-signin d-flex align-items-center justify-content-center my-5 my-lg-0">
            <div class="container-fluid">
                <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-3">
                    <div class="col mx-auto">
                        <div class="mb-4 text-center">
                            <img src="{{asset('assets/images/logo.png')}}" width="140" height="100" alt="" />
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="border p-4 rounded">
                                    <div class="login-separater text-center mb-4"> <p>{{__("messages.login_to_begin_your_session")}}</p>
                                        <hr/>
                                    </div>
                                    <div class="form-body">
                                        <form class="row g-3" action="{{ route('authentication') }}" method="post">
                                            @csrf

                                            @if ($errors->has('error'))
                                                <div class="text-danger">{{ $errors->first('error') }}</div>
                                            @endif

                                            <div class="col-12">
                                                <label for="inputEmailAddress" class="form-label">{{__("auth.phone_number")}}</label>
                                                <input type="number"  name="phone_number" class="form-control" id="inputEmailAddress" required placeholder="{{__("auth.enter_phone_number")}}">
                                            </div>

                                            <div class="col-12">
                                                <label for="inputChoosePassword" class="form-label">{{__("auth.password")}}</label>
                                                <div class="input-group" id="show_hide_password">
                                                    <input type="password"  name="password" class="form-control border-end-0" id="inputChoosePassword" required placeholder="{{__("auth.enter_password")}}"> <a href="javascript:" class="input-group-text bg-transparent"><i class='bx bx-hide'></i></a>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckChecked" checked>
                                                    <label class="form-check-label" for="flexSwitchCheckChecked">{{__("auth.remember_me")}}</label>
                                                </div>
                                            </div>

                                            <div class="col-md-6 text-end">	<a href="#">{{__("auth.forgot_password")}}</a>
                                            </div>
                                            <div class="col-12">
                                                <div class="d-grid">
                                                    <button type="submit" class="btn btn-primary"><i class="bx bxs-lock-open"></i>{{__("auth.log_in")}}</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end row-->
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush
@endsection
