@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.lesson_details'), __(config('app.name'))))

@section("style")
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet">
@endsection

<?php
$arrayResult = array();
foreach ($lessonDetails->{"lessonProgressionDetails"} as $lessonDetail) {
    $arrayResult[] = array(
        "submitted_by" => $lessonDetail->{"submittedBy"}->{"first_name"} . " " . $lessonDetail->{"submittedBy"}->{"last_name"},
        "submitted_at" => $lessonDetail->{"submitted_at"},
        "submitter_phone_number" => $lessonDetail->{"submitter_phone_number"},
        "validated_at" => $lessonDetail->{"validated_at"},
        "validation_rejected_at" => $lessonDetail->{"validation_rejected_at"},
    );
}

$currentHistory = end($arrayResult);
?>
@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.recording")}}</div>
                <div class="ps-3">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0 p-0">
                            <li class="breadcrumb-item active" aria-current="page">{{__("messages.lesson_details")}}</li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="row g-0">
                    <div class="col-md-4 border-end">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center text-center">
                                <img src="{{asset('assets/images/avatars/avatar-2.png')}}" alt="Admin"
                                     class="rounded-circle p-1 bg-primary" width="110">
                                <div class="mt-3">
                                    <h4>{{$currentHistory["submitted_by"] }}</h4>
                                    <p class="text-secondary mb-1">{{$currentHistory["submitter_phone_number"] }}</p>
                                    <p class="text-muted font-size-sm">{{$lessonDetails->{"inspectorate"}->{"designation"} }}</p>
                                </div>
                            </div>
                            <hr class="my-4"/>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                    <h6 class="mb-0 bx-download"> PowerPoint</h6>
                                    <span class="text-secondary bx-download">https://codervent.com</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-9">
                                    <h4 class="card-title">{{$lessonDetails->{"title"} }}</h4>
                                </div>
                                <div class="col-md-3">
                                    <button type="button" <?php

                                        $style = match ($lessonDetails->{"status"}) {
                                            config('minesec.validation_status.pending') => "class='btn btn-warning px-3 float-end'",

                                            config('minesec.validation_status.rejected'),
                                            config('minesec.validation_status.validation_rejected'),
                                            config('minesec.validation_status.recording_rejected'),
                                            config('minesec.validation_status.editing_rejected'),
                                            config('minesec.validation_status.segmentation_rejected'),
                                            => "class='btn btn-danger px-3 float-end'",

                                            config('minesec.validation_status.validated'),
                                            config('minesec.validation_status.recorded'),
                                            config('minesec.validation_status.edited'),
                                            config('minesec.validation_status.segmented'),
                                            config('minesec.validation_status.put_in_claas'),
                                            => "class='btn btn-success px-3 float-end'",
                                            default => null,
                                        };

                                        echo $style;

                                        ?> ></i> <?php echo $lessonDetails->{"status"} ?></button>
                                </div>
                            </div>


                            <div class="d-flex gap-3 py-3">
                                <div>142 reviews</div>
                                <div class="text-success"><i class='bx bxs-cart-alt align-middle'></i> 134 orders</div>
                            </div>
                            <dl class="row">
                                <dt class="col-sm-3">Status</dt>
                                <dd class="col-sm-9 text-success">Odsy-1000</dd>

                                <dt class="col-sm-3">Inspectorate</dt>
                                <dd class="col-sm-9">{{$lessonDetails->{"inspectorate"}->{"designation"}  }}</dd>

                                <dt class="col-sm-3">Sub system</dt>
                                <dd class="col-sm-9">{{$lessonDetails->{"subSystem"}->{"designation"}  }}</dd>

                                <dt class="col-sm-3">Education type</dt>
                                <dd class="col-sm-9">{{$lessonDetails->{"educationType"}->{"designation"}  }}</dd>

                                <dt class="col-sm-3">Class</dt>
                                <dd class="col-sm-9">{{$lessonDetails->{"className"}->{"designation"}  }}</dd>

                                <dt class="col-sm-3">Subject</dt>
                                <dd class="col-sm-9">{{$lessonDetails->{"subject"}->{"designation"}  }}</dd>
                            </dl>
                            <hr>
                            <div class="d-flex gap-3 mt-3">
                                <a type="button" class="btn btn-primary px-5 radius-30 show-approve-modal"
                                   data-lesson_id="{{$lessonDetails->{"id"} }}"
                                   data-lesson_title="{{$lessonDetails->{"title"} }}"
                                   data-lesson_type="{{$lessonDetails->{"type"} }}">{{__("messages.approve")}}</a>

                                <button type="button" class="btn btn-danger px-5 radius-30 show-reject-modal"
                                        data-lesson_id="{{$lessonDetails->{"id"} }}"
                                        data-lesson_title="{{$lessonDetails->{"title"} }}"
                                        data-lesson_type="{{$lessonDetails->{"type"} }}">{{__("messages.reject")}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card radius-10">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div>
                            <h6 class="mb-0">Lesson History</h6>
                        </div>
                        <div class="dropdown ms-auto">
                            <a class="dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown"><i
                                    class="bx bx-dots-horizontal-rounded font-22 text-option"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="javascript:;">Action</a>
                                </li>
                                <li><a class="dropdown-item" href="javascript:;">Another action</a>
                                </li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="javascript:;">Something else here</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>Validated/Rejected by</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Recorded/Rejected by</th>
                                <th>Date</th>
                                <th>Reason for rejection</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($lessonDetails->{"lessonProgressionDetails"} as $lessonProgressionDetail)
                                <tr>
                                    <td>{{$lessonProgressionDetail->{"validated_at"} != null ? (isset($lessonProgressionDetail->{"validatedBy"}) ? $lessonProgressionDetail->{"validatedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"validatedBy"}->{"last_name"} : "") : (isset($lessonProgressionDetail->{"validationRejectedBy"}) ? $lessonProgressionDetail->{"validationRejectedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"validationRejectedBy"}->{"last_name"} : "")  }}</td>
                                    <td>{{date_format($lessonProgressionDetail->{"submitted_at"}, "Y-m-d h:s") }}</td>
                                    <td><span <?php if ($lessonProgressionDetail->{"validated_at"} == null && $lessonProgressionDetail->{"validation_rejected_at"} == null && $lessonProgressionDetail->{"recorded_at"} == null && $lessonProgressionDetail->{"recording_rejected_at"} == null) {
                                            echo "class='badge bg-gradient-blooker text-white shadow-sm w-100'";
                                        } elseif ($lessonProgressionDetail->{"validated_at"} != null) {
                                            echo "class='badge bg-gradient-quepal text-white shadow-sm w-100'";
                                        } elseif ($lessonProgressionDetail->{"validated_at"} == null && $lessonProgressionDetail->{"validation_rejected_at"} != null) {
                                            echo "class='badge bg-gradient-bloody text-white shadow-sm w-100'";
                                        } elseif ($lessonProgressionDetail->{"recorded_at"} != null && $lessonProgressionDetail->{"recording_rejected_at"} == null) {
                                            echo "class='badge bg-gradient-quepal text-white shadow-sm w-100'";
                                         } elseif ($lessonProgressionDetail->{"recorded_at"} == null && $lessonProgressionDetail->{"recording_rejected_at"} != null)
                                            echo "class='badge bg-gradient-bloody text-white shadow-sm w-100'";
                                        ?>>
                                            <?php
                                            if ($lessonProgressionDetail->{"validated_at"} == null && $lessonProgressionDetail->{"validation_rejected_at"} == null && $lessonProgressionDetail->{"recorded_at"} == null && $lessonProgressionDetail->{"recording_rejected_at"} == null) {
                                                echo "Pending";
                                            } elseif ($lessonProgressionDetail->{"validated_at"} != null) {
                                                echo "Validated";
                                            } elseif ($lessonProgressionDetail->{"validated_at"} == null && $lessonProgressionDetail->{"validation_rejected_at"} != null) {
                                                echo "Rejected";
                                            } elseif ($lessonProgressionDetail->{"recorded_at"} != null && $lessonProgressionDetail->{"recording_rejected_at"} == null) {
                                                echo "Recorded";
                                            } elseif ($lessonProgressionDetail->{"recorded_at"} == null && $lessonProgressionDetail->{"recording_rejected_at"} != null)
                                                echo "Validation rejected";
                                            ?>
                                    </span></td>
                                    <td>{{$lessonProgressionDetail->{"recorded_at"} != null ? (isset($lessonProgressionDetail->{"recordedBy"}) ? $lessonProgressionDetail->{"recordedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"recordedBy"}->{"last_name"} : "") : (isset($lessonProgressionDetail->{"recordingRejectedBy"}) ? $lessonProgressionDetail->{"recordingRejectedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"recordingRejectedBy"}->{"last_name"} : "")  }}</td>
                                    <td>{{$lessonProgressionDetail->{"recorded_at"} != null ? (isset($lessonProgressionDetail->{"recorded_at"}) ? date_format($lessonProgressionDetail->{"recorded_at"}, "Y-m-d h:s") : "") :  (isset($lessonProgressionDetail->{"recording_rejected_at"}) ? date_format($lessonProgressionDetail->{"recording_rejected_at"}, "Y-m-d h:s") : "" )}}</td>
                                    <td>{{$lessonProgressionDetail->{"recording_rejection_reason"} }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <!-- Approve Modal -->
        @include("admin.lesson.recording.modals.approve_modal")

        <!-- Reject Modal -->
            @include("admin.lesson.recording.modals.reject_modal")
        </div>
    </div>
    <!--end page wrapper -->
@endsection


@section("script")
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.3.0/jquery.form.min.js"></script>

    <script>
        $(document).ready(function (e) {

            let currentLessonId = null;

            $(document).on('click', '.show-approve-modal', function (e) {
                currentLessonId = $(this).data('lesson_id');
                let lesson_title = $(this).data('lesson_title');

                $("#lesson_title").html(lesson_title);

                $('#approveModal').modal('show');
            });

            $('#approveForm').ajaxForm({
                beforeSend: function () {
                    $('#approve-response').empty();
                    $(".spinner").removeClass('d-none');
                    $(".action-buttons-wrapper").addClass('d-none');
                },
                complete: function (data) {
                    if (data.responseJSON.error) {
                        $(".btn-cancel-action").prop("enabled", true);
                        $(".btn-approve-action").prop("enabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#approve-response').html('<span class="text-danger"><b>' + data.responseJSON.error + '</b></span>');
                    }

                    if (data.responseJSON.success) {
                        $(".btn-cancel-action").prop("disabled", true);
                        $(".btn-approve-action").prop("disabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#approve-response').html('<span class="text-success"><b>' + data.responseJSON.success + '</b></span>');
                        window.setTimeout(function () {
                            window.location.reload();
                        }, 2500)
                    }
                },
                error: function () {
                    $(".btn-cancel-action").prop("enabled", true);
                    $(".btn-approve-action").prop("enabled", true);
                    $(".spinner").addClass('d-none');
                    $(".action-buttons-wrapper").removeClass('d-none');
                    alert("<?php echo __("error.generic_error") ?>");
                }
            });

            $(document).on('click', '.show-reject-modal', function (e) {
                currentLessonId = $(this).data('lesson_id');
                let lessonTitle = $(this).data('lesson_title');
                $("#lessonTitle").html(lessonTitle);

                $('#rejectModal').modal('show');
            });

            $('#rejectForm').ajaxForm({
                beforeSend: function () {
                    $('#reject-response').empty();
                    $(".spinner").removeClass('d-none');
                    $(".action-buttons-wrapper").addClass('d-none');
                },
                complete: function (data) {

                    if (data.responseJSON.error) {
                        $(".btn-cancel-action").prop("enabled", true);
                        $(".btn-reject-action").prop("enabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#reject-response').html('<span class="text-danger"><b>' + data.responseJSON.error + '</b></span>');
                    }

                    if (data.responseJSON.success) {
                        $(".btn-cancel-action").prop("disabled", true);
                        $(".btn-reject-action").prop("disabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#reject-response').html('<span class="text-success"><b>' + data.responseJSON.success + '</b></span>');
                        window.setTimeout(function () {
                            window.location.reload();
                        }, 2500)
                    }
                },
                error: function () {
                    $(".btn-cancel-action").prop("enabled", true);
                    $(".btn-reject-action").prop("enabled", true);
                    $(".spinner").addClass('d-none');
                    $(".action-buttons-wrapper").removeClass('d-none');
                    alert("<?php echo __("error.generic_error") ?>");
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endsection
