<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info('Creating default users... ');

        $defaultUsers = config("seeder.default_users");
        foreach ($defaultUsers as $user) {
            $user = User::factory()->create([
                'first_name' => $user["first_name"],
                'last_name' => $user["last_name"],
                'phone_number' => $user["phone_number"],
                'locale' => $user["locale"],
                'gender' => $user["gender"],
                'active' => $user["active"],
                'verified_at' => $user["verified_at"]
            ]);

            $user->assignRole('Super Admin');
        }

    }
}
