<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('program_coverages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('school');
            $table->bigInteger('school_id')->unsigned();
            $table->foreign('school_id')->references('id')->on('schools')->onUpdate('cascade')->onDelete('cascade');

            $table->string('inspector_name');
            $table->bigInteger('inspector_user_id')->unsigned();
            $table->foreign('inspector_user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_system_id')->unsigned();
            $table->foreign('sub_system_id')->references('id')->on('sub_systems')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('education_type_id')->unsigned();
            $table->foreign('education_type_id')->references('id')->on('education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_education_type_id')->unsigned()->nullable();
            $table->foreign('sub_education_type_id')->references('id')->on('sub_education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('specialty_id')->unsigned()->nullable();
            $table->foreign('specialty_id')->references('id')->on('specialties')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('level_id')->unsigned()->nullable();
            $table->foreign('level_id')->references('id')->on('levels')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('class_id')->unsigned();
            $table->foreign('class_id')->references('id')->on('classes')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('subjects')->onUpdate('cascade')->onDelete('cascade');

            $table->string('number_of_lessons_programmed');
            $table->string('number_of_lessons_done');
            $table->string('percentage_number_of_lessons_done');
            $table->text('comment_number_of_lessons_done');

            $table->string('number_of_teaching_hours');
            $table->string('number_of_hours_taught');
            $table->string('percentage_number_of_hours_taught');
            $table->text('comment_number_of_hours_taught');

            $table->string('number_of_lessons_to_digitalised');
            $table->string('number_of_lessons_digitalised');
            $table->string('percentage_number_of_lessons_digitalised');
            $table->text('comment_number_of_lessons_digitalised');

            $table->string('ots_effective');
            $table->string('number_of_ots_participants');
            $table->string('number_of_seminars_organised');
            $table->string('number_of_seminar_participants');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('program_coverages');
    }
};
