<?php

use App\Enums\LessonValidationEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lesson_progressions', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->unsignedBigInteger('inspectorate_id')->unsigned();
            $table->foreign('inspectorate_id')->references('id')->on('inspectorates')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_system_id')->unsigned();
            $table->foreign('sub_system_id')->references('id')->on('sub_systems')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('education_type_id')->unsigned();
            $table->foreign('education_type_id')->references('id')->on('education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_education_type_id')->unsigned()->nullable();
            $table->foreign('sub_education_type_id')->references('id')->on('sub_education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('specialty_id')->unsigned()->nullable();
            $table->foreign('specialty_id')->references('id')->on('specialties')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('level_id')->unsigned()->nullable();
            $table->foreign('level_id')->references('id')->on('levels')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('class_id')->unsigned();
            $table->foreign('class_id')->references('id')->on('classes')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('subject_id')->unsigned();
            $table->foreign('subject_id')->references('id')->on('subjects')->onUpdate('cascade')->onDelete('cascade');

            $table->string('type',10);
            $table->string('title',256);
            $table->string('path',256);
            $table->string('description',256);
            $table->string('status')->default(LessonValidationEnum::pending->value);

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lesson_progressions');
    }
};
