<?php

namespace App\Services;

use App\Models\Term;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait TermService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Term::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Create term
     *
     * @return Builder[]|Collection
     */
    public static function allTerms(): Collection|array
    {

        return Term::query()->get();
    }

    /**
     * Find by id
     *
     * @param int $id
     * @return Model|Builder|null
     */
    public static function findById(int $id): Model|Builder|null
    {
        return Term::query()->where('id', $id)->first();
    }

    /**
     * Create term
     *
     * @param string $designation
     * @return Builder|Model
     */
    public static function createTerm(string $designation): Model|Builder
    {
        return self::store([
            "designation" => $designation
        ]);
    }

    /**
     * Update tem with given id
     *
     * @param int $id
     * @param string $designation
     * @return int|null
     */
    public static function updateTerm(int $id, string $designation): ?int
    {
        try {
            $term = Term::query()->where('id', $id)->update(['designation' => $designation]);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'TermService::updateTerm');
            $term = null;
        }

        return $term;
    }

    /**
     * Delete term with given id
     *
     * @param int $id
     * @return int|null
     */
    public  static function deleteTerm(int $id): ?int
    {
        try {
            $term = Term::destroy($id);

        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'TermService::deleteTerm');
            $term = null;
        }

        return $term;
    }
}
