<?php

namespace App\Services;

use App\Models\LessonProgressionDetail;
use App\Models\User;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait LessonProgressionDetailsService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return LessonProgressionDetail::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * FInd by id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return LessonProgressionDetail::query()->find($id);
    }

    /**
     * Find by lesson progression id
     *
     * @param int $lessonProgressionId
     * @return Builder[]|Collection
     */
    public static function findByLessonProgressionId(int $lessonProgressionId): Collection|array
    {
        return LessonProgressionDetail::query()->where("lesson_progression_id", $lessonProgressionId)->get();
    }

    /**
     * Create general education lesson progression details
     *
     * @param array $data
     * @param User $user
     * @param int $lessonProgressionId
     * @return Model|Builder|null
     */
    public static function submitGeneralEducationLessonDetails(array $data, User $user, int $lessonProgressionId): Model|Builder|null
    {
        try {
            $lessonProgressionDetails = LessonProgressionDetail::store([
                'lesson_progression_id' => $lessonProgressionId,
                'submitted_by' => $user->{"id"},
                'submitted_at' => now(),
                'submitter_phone_number' => $user->{"phone_number"},

                'validated_by' => null,
                'validated_at' => null,
                'validation_rejected_by' => null,
                'validation_rejected_at' => null,
                'validation_rejection_reason' => null,

                'recorded_by' => null,
                'recorded_at' => null,
                'recording_rejected_by' => null,
                'recording_rejected_at' => null,
                'recording_rejection_reason' => null,

                'mounted_by' => null,
                'mounted_at' => null,
                'mounting_rejected_by' => null,
                'mounting_rejected_at' => null,
                'mounting_rejection_reason' => null,

                'published_by' => null,
                'published_at' => null,
                'publishing_rejected_by' => null,
                'publishing_rejected_at' => null,
                'publishing_rejection_reason' => null,

                'put_in_classes_by' => null,
                'put_in_classes_at' => null,
                'put_in_classes_rejected_by' => null,
                'put_in_classes_rejected_at' => null,
                'put_in_classes_rejection_reason' => null,
            ]);

            $results = $lessonProgressionDetails;
        } catch (Exception $exception) {
            log_debug($exception, "LessonProgressionDetailsService::submitGeneralEducationLessonDetails");
            $results = null;
        }

        return $results;
    }

    /**
     * Create technical education lesson progression details
     *
     * @param array $data
     * @param User $user
     * @param int $lessonProgressionId
     * @return Builder|Model|null
     */
    public static function submitTechnicalEducationLessonDetails(array $data, User $user, int $lessonProgressionId): Model|Builder|null
    {
        try {
            $lessonProgressionDetails = LessonProgressionDetail::store([
                'lesson_progression_id' => $lessonProgressionId,
                'submitted_by' => $user->{"id"},
                'submitted_at' => now(),
                'submitter_phone_number' => $user->{"phone_number"},
                'validated_by' => null,
                'validated_at' => null,
                'validation_rejected_by' => null,
                'validation_rejected_at' => null,
                'validation_rejection_reason' => null,

                'recorded_by' => null,
                'recorded_at' => null,
                'recording_rejected_by' => null,
                'recording_rejected_at' => null,
                'recording_rejection_reason' => null,

                'mounted_by' => null,
                'mounted_at' => null,
                'mounting_rejected_by' => null,
                'mounting_rejected_at' => null,
                'mounting_rejection_reason' => null,

                'published_by' => null,
                'published_at' => null,
                'publishing_rejected_by' => null,
                'publishing_rejected_at' => null,
                'publishing_rejection_reason' => null,

                'put_in_classes_by' => null,
                'put_in_classes_at' => null,
                'put_in_classes_rejected_by' => null,
                'put_in_classes_rejected_at' => null,
                'put_in_classes_rejection_reason' => null,
            ]);

            $results = $lessonProgressionDetails;
        } catch (Exception $exception) {
            log_debug($exception, "LessonProgressionDetailsService::submitTechnicalEducationLessonDetails");
            $results = null;
        }

        return $results;
    }

    /**
     * Create teacher training lesson progression details
     *
     * @param $data
     * @param $user
     * @param int $lessonProgressionId
     * @return Builder|Model|null
     */
    public static function submitTeacherTrainingLessonDetails($data, $user, int $lessonProgressionId): Model|Builder|null
    {
        try {
            $lessonProgressionDetails = LessonProgressionDetail::store([
                'lesson_progression_id' => $lessonProgressionId,
                'submitted_by' => $user->{"id"},
                'submitted_at' => now(),
                'submitter_phone_number' => $user->{"phone_number"},
                'validated_by' => null,
                'validated_at' => null,
                'validation_rejected_by' => null,
                'validation_rejected_at' => null,
                'validation_rejection_reason' => null,

                'recorded_by' => null,
                'recorded_at' => null,
                'recording_rejected_by' => null,
                'recording_rejected_at' => null,
                'recording_rejection_reason' => null,

                'mounted_by' => null,
                'mounted_at' => null,
                'mounting_rejected_by' => null,
                'mounting_rejected_at' => null,
                'mounting_rejection_reason' => null,

                'published_by' => null,
                'published_at' => null,
                'publishing_rejected_by' => null,
                'publishing_rejected_at' => null,
                'publishing_rejection_reason' => null,

                'put_in_classes_by' => null,
                'put_in_classes_at' => null,
                'put_in_classes_rejected_by' => null,
                'put_in_classes_rejected_at' => null,
                'put_in_classes_rejection_reason' => null,
                ]);

            $results = $lessonProgressionDetails;
        } catch (Exception $exception) {
            log_debug($exception, "LessonProgressionDetailsService::submitTeacherTrainingLessonDetails");
            $results = null;
        }

        return $results;
    }

}
