<?php

namespace App\Services;

use App\Models\Classes;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait ClassService
{

    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Classes::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all classes
     *
     * @return Builder[]|Collection
     */
    public  static  function allClasses(): Collection|array
    {

        return Classes::query()->get();
    }


    /**
     * Find by given id
     *
     * @param int $id
     * @return Model|Builder|null
     */
    public static  function findById(int $id): Model|Builder|null
    {
        return Classes::query()->where('id', $id)->first();
    }


    /**
     * Create class
     *
     * @param string $designation
     * @return Builder|Model
     */
    public static function createClass(string $designation): Model|Builder
    {
        return self::store([
            "designation" => $designation
        ]);
    }

    /**
     * Update class with given id
     *
     * @param int $id
     * @param string $designation
     * @return int|null
     */
    public static function updateClass(int $id, string $designation): ?int
    {
        try {
            $class = Classes::query()->where('id', $id)->update(['designation' => $designation]);
        } catch (\Exception $exception) {
            log_debug($exception, "ClassService::updateClass");
            $class = null;
        }

        return $class;
    }

    /**
     * Delete class with given id
     *
     * @param int $id
     * @return int|null
     */
    public static function deleteClass(int $id): ?int
    {
        try {
            $class = Classes::destroy($id);
        } catch (\Exception $exception) {
            log_debug($exception, "ClassService::deleteClass");
            $class = null;
        }

        return $class;
    }
}
