<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class InspectorateRules
{
    /**
     * Create rule
     *
     */
    #[ArrayShape(["designation" => "string"])] public static function create(): array
    {
        return [
            "designation" => "required|max:80",
        ];
    }

    /**
     * Edit rule
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:inspectorates",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:inspectorates",
            "designation" => "required|max:80",
        ];
    }

    /**
     * Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:inspectorates",
        ];
    }

    /**
     * Create personnel rule
     *
     * @return array
     */
    #[ArrayShape(["inspectorate_id" => "string", "role" => "string[]", "first_name" => "string", "last_name" => "string", "gender" => "string", "locale" => "string[]", "phone_number" => "string", "password" => "string", 'profile_picture' => "string[]"])] public static function createPersonnel(): array
    {

        $imageExtensions = config('minesec.constants.image_extensions');
        $imageMaxSize = config('minesec.constants.max_file_size');

        return [
            "inspectorate_id" => "required|int|exists:inspectorates,id",
            "role" => [
                'required',
                'in:' . implode(",", array_values(config('minesec.roles')))
            ],
            "first_name" => "required|string",
            "last_name" => "required|string",
            "gender" => [
                'required',
                'string:' . implode(",", array_values(config('minesec.gender')))
            ],
            "locale" => [
                'required',
                'in:' . implode(",", array_values(config('minesec.locales')))
            ],
            "phone_number" => "required|integer|unique:users,phone_number",
            "password" => "required|string",
            'profile_picture' => ['sometimes', 'image', 'mimes:' . $imageExtensions, 'max:' . $imageMaxSize],
        ];
    }

    /**
     * Update personnel rule
     *
     * @return array
     */
    #[ArrayShape(["id" => "string", "role" => "string[]", "first_name" => "string", "last_name" => "string", "gender" => "string[]", "locale" => "string[]", "phone_number" => "string", "password" => "string", 'profile_picture' => "string[]"])] public static function updatePersonnel(): array
    {
        $imageExtensions = config('minesec.constants.image_extensions');
        $imageMaxSize = config('minesec.constants.max_file_size');

        return [
            "id" => "required|int|exists:users,id",
            "role" => [
                'required',
                'in:' . implode(",", array_values(config('minesec.roles')))
            ],
            "first_name" => "required|string",
            "last_name" => "required|string",
            "gender" => [
                'required',
                'string:' . implode(",", array_values(config('minesec.gender')))
            ],
            "locale" => [
                'required',
                'in:' . implode(",", array_values(config('minesec.locales')))
            ],
            "phone_number" => "required|integer",
            'profile_picture' => ['sometimes', 'image', 'mimes:' . $imageExtensions, 'max:' . $imageMaxSize],
            ];
    }
}
