<?php

namespace App\RequestRules\Api;

use JetBrains\PhpStorm\ArrayShape;

class SubjectRules
{
    /**
     * Get general education class subjects rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "education_type_id" => "string", "class_id" => "string"])] public static function getGeneralEducationClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "education_type_id" => "required|integer|exists:education_types,id",
            "class_id" => "required|integer|exists:classes,id",
        ];
    }

    /**
     * Get technical education class subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "specialty_id" => "string", "specialty_class_id" => "string"])] public static function getTechnicalEducationClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
        ];
    }

    /**
     * Get teacher training class subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "level_id" => "string", "level_class_id" => "string"])] public static function getTeacherTrainingClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
        ];
    }
}
