<?php

namespace App\Models;

use App\Services\SubEducationTypeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubEducationType extends Model
{
    use HasFactory;
    use SoftDeletes;
    use SubEducationTypeService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'sub_education_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * Specialties that belong to sub education type
     *
     * @return BelongsToMany
     */
    public function specialties(): BelongsToMany
    {

        return $this->belongsToMany(Specialty::class, 'sub_education_type_specialties', 'sub_education_type_id', 'specialty_id');
    }
}
