<?php $__env->startSection('title', sprintf('%s - %s', __('messages.lesson_details'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php
$arrayResult = array();
foreach($lessonDetails->{"lessonProgressionDetails"} as $lessonDetail) {
    $arrayResult[] = array(
        "submitted_by" => $lessonDetail->{"submittedBy"}->{"first_name"}." ".$lessonDetail->{"submittedBy"}->{"last_name"},
        "submitted_at" => $lessonDetail->{"submitted_at"},
        "submitter_phone_number" => $lessonDetail->{"submitter_phone_number"},
        "validated_at" => $lessonDetail->{"validated_at"},
        "validation_rejected_at" => $lessonDetail->{"validation_rejected_at"},
    );
}

$currentHistory = end($arrayResult);
?>
<?php $__env->startSection("wrapper"); ?>
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.segmenting")); ?></div>
                <div class="ps-3">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0 p-0">
                            <li class="breadcrumb-item active" aria-current="page"><?php echo e(__("messages.lesson_details")); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="row g-0">
                    <div class="col-md-4 border-end">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center text-center">
                                <img src="<?php echo e(asset('assets/images/avatars/avatar-2.png')); ?>" alt="Admin" class="rounded-circle p-1 bg-primary" width="110">
                                <div class="mt-3">
                                    <h4><?php echo e($currentHistory["submitted_by"]); ?></h4>
                                    <p class="text-secondary mb-1"><?php echo e($currentHistory["submitter_phone_number"]); ?></p>
                                    <p class="text-muted font-size-sm"><?php echo e($lessonDetails->{"inspectorate"}->{"designation"}); ?></p>
                                </div>
                            </div>
                            <hr class="my-4" />
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                    <h6 class="mb-0 bx-download"> PowerPoint</h6>
                                    <span class="text-secondary bx-download">https://codervent.com</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-9">
                                    <h4 class="card-title"><?php echo e($lessonDetails->{"title"}); ?></h4>
                                </div>
                                <div class="col-md-3">
                                    <button type="button" <?php

                                        $style = match ($lessonDetails->{"status"}) {
                                            config('minesec.validation_status.pending') => "class='btn btn-warning px-3 float-end'",

                                            config('minesec.validation_status.rejected'),
                                            config('minesec.validation_status.validation_rejected'),
                                            config('minesec.validation_status.recording_rejected'),
                                            config('minesec.validation_status.editing_rejected'),
                                            config('minesec.validation_status.segmentation_rejected'),
                                            => "class='btn btn-danger px-3 float-end'",

                                            config('minesec.validation_status.validated'),
                                            config('minesec.validation_status.recorded'),
                                            config('minesec.validation_status.edited'),
                                            config('minesec.validation_status.segmented'),
                                            config('minesec.validation_status.put_in_claas'),
                                            => "class='btn btn-success px-3 float-end'",
                                            default => null,
                                        };

                                        echo $style;

                                        ?> ></i> <?php echo $lessonDetails->{"status"} ?></button>
                                </div>
                            </div>


                            <div class="d-flex gap-3 py-3">
                                <div>142 reviews</div>
                                <div class="text-success"><i class='bx bxs-cart-alt align-middle'></i> 134 orders</div>
                            </div>
                            <dl class="row">
                                <dt class="col-sm-3">Status</dt>
                                <dd class="col-sm-9 text-success">Odsy-1000</dd>

                                <dt class="col-sm-3">Inspectorate</dt>
                                <dd class="col-sm-9"><?php echo e($lessonDetails->{"inspectorate"}->{"designation"}); ?></dd>

                                <dt class="col-sm-3">Sub system</dt>
                                <dd class="col-sm-9"><?php echo e($lessonDetails->{"subSystem"}->{"designation"}); ?></dd>

                                <dt class="col-sm-3">Education type</dt>
                                <dd class="col-sm-9"><?php echo e($lessonDetails->{"educationType"}->{"designation"}); ?></dd>

                                <dt class="col-sm-3">Class</dt>
                                <dd class="col-sm-9"><?php echo e($lessonDetails->{"className"}->{"designation"}); ?></dd>

                                <dt class="col-sm-3">Subject</dt>
                                <dd class="col-sm-9"><?php echo e($lessonDetails->{"subject"}->{"designation"}); ?></dd>
                            </dl>
                            <hr>
                            <div class="d-flex gap-3 mt-3">
                                <a type="button" class="btn btn-primary px-5 radius-30 show-approve-modal" data-lesson_id="<?php echo e($lessonDetails->{"id"}); ?>" data-lesson_title="<?php echo e($lessonDetails->{"title"}); ?>" data-lesson_type="<?php echo e($lessonDetails->{"type"}); ?>"><?php echo e(__("messages.approve")); ?></a>

                                <button type="button" class="btn btn-danger px-5 radius-30 show-reject-modal" data-lesson_id="<?php echo e($lessonDetails->{"id"}); ?>" data-lesson_title="<?php echo e($lessonDetails->{"title"}); ?>" data-lesson_type="<?php echo e($lessonDetails->{"type"}); ?>"><?php echo e(__("messages.reject")); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card radius-10">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div>
                            <h6 class="mb-0">Lesson History</h6>
                        </div>
                        <div class="dropdown ms-auto">
                            <a class="dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown"><i class="bx bx-dots-horizontal-rounded font-22 text-option"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="javascript:;">Action</a>
                                </li>
                                <li><a class="dropdown-item" href="javascript:;">Another action</a>
                                </li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="javascript:;">Something else here</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>Edited/Rejected by</th>
                                <th>Date</th>
                                <th>Reason for rejection</th>
                                <th>Status</th>
                                <th>Segmented/Rejected by</th>
                                <th>Date</th>
                                <th>Reason for rejection</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $lessonDetails->{"lessonProgressionDetails"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessonProgressionDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($lessonProgressionDetail->{"status"} == config('minesec.validation_stage_status.lesson_edited')): ?>
                                <tr>
                                    <td><?php echo e($lessonProgressionDetail->{"editedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"editedBy"}->{"last_name"}); ?></td>
                                    <td><?php echo e(date_format(\Carbon\Carbon::parse($lessonProgressionDetail->{"edited_at"}), "Y-m-d h:i:s")); ?></td>
                                    <td></td>
                                    <td><span <?php echo "class='badge bg-gradient-quepal text-white shadow-sm w-100'"; ?>><?php echo __("Messages.lesson_edited"); ?>
                                    </span></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <?php endif; ?>
                                <?php if($lessonProgressionDetail->{"status"} == config('minesec.validation_stage_status.editing_rejected')): ?>
                                 <tr>
                                        <td><?php echo e($lessonProgressionDetail->{"editingRejectedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"editingRejectedBy"}->{"last_name"}); ?></td>
                                        <td><?php echo e(date_format(\Carbon\Carbon::parse($lessonProgressionDetail->{"editing_rejected_at"}), "Y-m-d h:i:s")); ?></td>
                                         <td><?php echo e($lessonProgressionDetail->{"editing_rejection_reason"}); ?></td>
                                        <td>
                                        <span <?php  echo "class='badge bg-gradient-bloody text-white shadow-sm w-100'"; ?>><?php echo __("messages.editing_rejected"); ?>
                                    </span>
                                        </td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if($lessonProgressionDetail->{"status"} == config('minesec.validation_stage_status.lesson_segmented')): ?>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                        <span <?php  echo "class='badge bg-gradient-quepal text-white shadow-sm w-100'"; ?>><?php echo __("messages.lesson_segmented"); ?>
                                    </span>
                                        </td>
                                        <td><?php echo e($lessonProgressionDetail->{"segmentedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"segmentedBy"}->{"last_name"}); ?></td>
                                        <td><?php echo e(date_format(\Carbon\Carbon::parse($lessonProgressionDetail->{"segmented_at"}), "Y-m-d h:i:s")); ?></td>
                                        <td><?php echo e($lessonProgressionDetail->{"segmenting_rejection_reason"}); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if($lessonProgressionDetail->{"status"} == config('minesec.validation_stage_status.segmentation_rejected')): ?>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                        <span <?php  echo "class='badge bg-gradient-bloody text-white shadow-sm w-100'"; ?>><?php echo __("messages.segmentation_rejected"); ?>
                                    </span>
                                        </td>
                                        <td><?php echo e($lessonProgressionDetail->{"segmentationRejectedBy"}->{"first_name"}." ".$lessonProgressionDetail->{"segmentationRejectedBy"}->{"last_name"}); ?></td>
                                        <td><?php echo e(date_format(\Carbon\Carbon::parse($lessonProgressionDetail->{"segmentation_rejected_at"}), "Y-m-d h:i:s")); ?></td>
                                        <td><?php echo e($lessonProgressionDetail->{"segmentation_rejection_reason"}); ?></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <!-- Approve Modal -->
        <?php echo $__env->make("admin.lesson.segmenting.modals.approve_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Reject Modal -->
            <?php echo $__env->make("admin.lesson.segmenting.modals.reject_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <!--end page wrapper -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection("script"); ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/4.3.0/jquery.form.min.js"></script>

    <script>
        $(document).ready(function (e) {

            let currentLessonId = null;

            $(document).on('click','.show-approve-modal',function(e) {
                currentLessonId = $(this).data('lesson_id');
                let lesson_title = $(this).data('lesson_title');

                $("#lesson_title").html(lesson_title);

                $('#approveModal').modal('show');
            });

            $('#approveForm').ajaxForm({
                beforeSend: function () {
                    $('#approve-response').empty();
                    $(".spinner").removeClass('d-none');
                    $(".action-buttons-wrapper").addClass('d-none');
                },
                complete: function (data) {
                    if(data.responseJSON.error)
                    {
                        $(".btn-cancel-action").prop("enabled", true);
                        $(".btn-approve-action").prop("enabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#approve-response').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                    }

                    if(data.responseJSON.success)
                    {
                        $(".btn-cancel-action").prop("disabled", true);
                        $(".btn-approve-action").prop("disabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#approve-response').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                        window.setTimeout(function(){
                            window.location.reload();
                        },2500)
                    }
                },
                error: function () {
                    $(".btn-cancel-action").prop("enabled", true);
                    $(".btn-approve-action").prop("enabled", true);
                    $(".spinner").addClass('d-none');
                    $(".action-buttons-wrapper").removeClass('d-none');
                    alert("<?php echo __("error.generic_error") ?>");
                }
            });

            $(document).on('click','.show-reject-modal',function(e) {
                currentLessonId = $(this).data('lesson_id');
                let lessonTitle = $(this).data('lesson_title');
                $("#lessonTitle").html(lessonTitle);

                $('#rejectModal').modal('show');
            });

            $('#rejectForm').ajaxForm({
                beforeSend: function () {
                    $('#reject-response').empty();
                    $(".spinner").removeClass('d-none');
                    $(".action-buttons-wrapper").addClass('d-none');
                },
                complete: function (data) {

                    if(data.responseJSON.error)
                    {
                        $(".btn-cancel-action").prop("enabled", true);
                        $(".btn-reject-action").prop("enabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#reject-response').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                    }

                    if(data.responseJSON.success)
                    {
                        $(".btn-cancel-action").prop("disabled", true);
                        $(".btn-reject-action").prop("disabled", true);
                        $(".spinner").addClass('d-none');
                        $(".action-buttons-wrapper").removeClass('d-none');
                        $('#reject-response').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                        window.setTimeout(function(){
                            window.location.reload();
                        },2500)
                    }
                },
                error: function () {
                    $(".btn-cancel-action").prop("enabled", true);
                    $(".btn-reject-action").prop("enabled", true);
                    $(".spinner").addClass('d-none');
                    $(".action-buttons-wrapper").removeClass('d-none');
                    alert("<?php echo __("error.generic_error") ?>");
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/lesson/segmenting/details.blade.php ENDPATH**/ ?>