<?php $__env->startSection('title', sprintf('%s - %s', __('messages.assign_permissions'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

        <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.assign_permissions_to_role")); ?></div>
            </div>
            <!--end breadcrumb-->
            <div class="card">
                <div class="card-body">
                    <div id="invoice">
                        <div class="invoice overflow-auto">
                            <div style="min-width: 600px">
                                <main>
                                    <form action="<?php echo e(route("role-permission.create")); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="role_id" value="<?php echo e($role->{"id"}); ?>">
                                        <div class="row contacts">
                                            <div class="col invoice-to">
                                                <h4 class="to"><?php echo e(__("messages.assign_permission_to")); ?>: <?php echo e($role->{"name"}); ?> </h4>
                                            </div>
                                        </div>
                                        <table>
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__("messages.module")); ?></th>
                                                <th class="text-left"><?php echo e(__("messages.feature")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $permissionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissionGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="no"><?php echo e($permissionGroup["designation"]); ?></td>

                                                    <td class="text-left">
                                                        <?php $__currentLoopData = $permissionGroup["permission_Categories"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissionCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <h6><?php echo e($permissionCategory["designation"]); ?></h6>
                                                    <?php $__currentLoopData = $permissionCategory->{"permissions"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="form-check form-check-right">
                                                                    <input class="form-check-input" type="checkbox" name="permissionIds[]" value="<?php echo e($permission->{"id"}); ?>"
                                                                    <?php $__currentLoopData = $roleHasPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roleHasPermission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php echo e($roleHasPermission->{"permission_id"} == $permission->{"id"} ? 'checked' : ''); ?>

                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    ><label class="font-size-16 text-muted mb-0 float-none"><?php echo e($permission->{"name"}); ?> </label>
                                                                </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    <div class="col-12">
                                                        <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                                    </div></td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </form>
                                </main>
                            </div>
                            <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                            <div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentTermId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentTermId = $(this).data('term_id');
                let term_name = $(this).data('term_name');
                $("#term_name").html(term_name);
                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();
                if(currentTermId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("term.delete")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentTermId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("term.index")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/settings/role_permission/permission.blade.php ENDPATH**/ ?>