<?php
$serverLang = '';
if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
    $serverLang = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
}
$browserLocale = substr($serverLang, 0, 2);

//$browserLocale = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
$defaultLocale = config("minesec.locales_keys.en");
app()->setLocale($browserLocale ?? $defaultLocale);
?>

<!DOCTYPE html>
<html lang="">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>" type="image/png" />
    <!-- loader-->
    <link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">
    <title><?php echo e(__(config('app.name'))); ?></title>
</head>

<body class="bg-theme bg-theme1">
<!-- wrapper -->
<div class="wrapper">
    <div class="error-404 d-flex align-items-center justify-content-center">
        <div class="container">
            <div class="card py-5">
                <div class="row g-0">
                    <div class="col col-xl-5">
                        <div class="card-body p-4">
                            <h1 class="display-1"><span class="text-primary">4</span><span class="text-danger">0</span><span class="text-success">4</span></h1>
                            <h2 class="font-weight-bold display-4"><?php echo e(__("error.lost_in_space")); ?></h2>
                            <p><?php echo e(__("error.edge_of_the_universe")); ?>

                                <br><?php echo e(__("error.page_not_found")); ?>

                                <br><?php echo e(__("error.return_to_home_page")); ?></p>
                            <div class="mt-5"> <a href="<?php echo e(route("dashboard")); ?>" class="btn btn-primary btn-lg px-md-5 radius-30"><?php echo e(__("messages.home")); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <img src="<?php echo e(asset('assets/images/errors-images/404-error.png')); ?>" class="img-fluid" alt="">
                    </div>
                </div>
                <!--end row-->
            </div>
        </div>
    </div>
</div>
<!-- end wrapper -->

<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/errors/404.blade.php ENDPATH**/ ?>