<?php $__env->startSection('title',  __('messages.dashboard')); ?>
<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/vectormap/jquery-jvectormap-2.0.2.css')); ?>" rel="stylesheet"/>

    <link href="<?php echo e(asset('assets/plugins/highcharts/css/highcharts.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

            <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">English Sub System</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["english_sub_system"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-primary ms-auto font-35"><i class='bx bx-book'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">General Education</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["general_education"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-danger ms-auto font-35"><i class='lni lni-school-bench-alt'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Technical Education</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["technical_education"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-warning ms-auto font-35"><i class='bx bx-cog'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Teacher Training</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["teacher_training"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-success ms-auto font-35"><i class='lni lni-blackboard'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Sous-système francophone</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["sous_systeme_francophone"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-primary ms-auto font-35"><i class='bx bx-book'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Enseignement Général</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["enseignement_general"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-danger ms-auto font-35"><i class='lni lni-school-bench-alt'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Enseignement Technique</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["enseignement_technique"], 0, '.', ',')); ?></h4>
                                </div>
                                <div class="text-warning ms-auto font-35"><i class='bx bx-cog'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <p class="mb-0 text-secondary">Enseignement Normal</p>
                                    <h4 class="my-1"><?php echo e(number_format($lessonStatistics["enseignement_Normal"], 0, '.',',')); ?></h4>
                                </div>
                                <div class="text-success ms-auto font-35"><i class='lni lni-blackboard'></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4">
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="text-center">
                                <div class="widgets-icons rounded-circle mx-auto bg-light-primary text-primary mb-3"><i class='bx bx-video'></i>
                                </div>
                                <h4 class="my-1"><?php echo e(number_format($lessonStatistics["total_lessons"], 0, '.', ',')); ?></h4>
                                <p class="mb-0 text-secondary"><?php echo e(__("messages.total_lessons")); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="text-center">
                                <div class="widgets-icons rounded-circle mx-auto bg-light-danger text-danger mb-3"><i class='lni lni-school-bench-alt'></i>
                                </div>
                                <h4 class="my-1"><?php echo e(number_format($lessonStatistics["total_general_education"], 0, '.', ',')); ?></h4>
                                <p class="mb-0 text-secondary"><?php echo e(__("messages.total_general_education")); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="text-center">
                                <div class="widgets-icons rounded-circle mx-auto bg-light-info text-info mb-3"><i class='bx bx-cog'></i>
                                </div>
                                <h4 class="my-1"><?php echo e(number_format($lessonStatistics["total_technical_education"], 0, '.', ',')); ?></h4>
                                <p class="mb-0 text-secondary"><?php echo e(__("messages.total_technical_education")); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="text-center">
                                <div class="widgets-icons rounded-circle mx-auto bg-light-success text-success mb-3"><i class='lni lni-blackboard'></i>
                                </div>
                                <h4 class="my-1"><?php echo e(number_format($lessonStatistics["total_teacher_training"], 0, '.', ',')); ?></h4>
                                <p class="mb-0 text-secondary"><?php echo e(__("messages.total_teacher_training")); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 col-lg-8">
                    <div class="card radius-10">
                        <div id="inspectorateStatistics"></div>
                    </div>
                </div>
                <div class="col-12 col-lg-4">
                    <div class="card radius-10">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div>
                                    <h6 class="mb-0"><?php echo e(__("messages.statistics_by_inspectorates")); ?></h6>
                                </div>
                            </div>
                            <div class="chart-container-2 mt-4">
                                <canvas id="inspectorateChart"></canvas>
                            </div>
                        </div>
                        <ul class="list-group list-group-flush">
                            <?php
                            $colors = ["bg-primary", "bg-secondary", "bg-success", "bg-danger", "bg-warning", "bg-info", "bg-primary", "bg-dark", "bg-success",];
                            ?>
                            <?php $__currentLoopData = $inspectorateArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inspectorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center"><?php echo e($inspectorate["designation"]); ?> <span class="badge <?php echo e($colors[$index]); ?> rounded-pill"><?php echo e($inspectorate["number_of_lessons"]); ?></span></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script src="<?php echo e(asset('assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/chartjs/js/Chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/chartjs/js/Chart.extension.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/index.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/plugins/highcharts/js/highcharts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/highcharts/js/variable-pie.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/highcharts/js/highcharts-custom.script.js')); ?>"></script>

    <script>
        (function () {
            "use strict";

            var inspectorateStatistics = <?php echo json_encode($inspectorateArray);  ?>

            // chart 2
            var ctx = document.getElementById("inspectorateChart").getContext('2d');

            var gradientStroke1 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke1.addColorStop(0, '#fc4a1a');
            gradientStroke1.addColorStop(1, '#f7b733');

            var gradientStroke2 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke2.addColorStop(0, '#4776e6');
            gradientStroke2.addColorStop(1, '#8e54e9');

            var gradientStroke3 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke3.addColorStop(0, '#ee0979');
            gradientStroke3.addColorStop(1, '#ff6a00');

            var gradientStroke4 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke4.addColorStop(0, '#42e695');
            gradientStroke4.addColorStop(1, '#3bb2b8');

            var gradientStroke5 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke5.addColorStop(0, '#ffc107');
            gradientStroke5.addColorStop(1, '#ffc107');

            var gradientStroke6 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke6.addColorStop(0, '#212529');
            gradientStroke6.addColorStop(1, '#212529');

            var gradientStroke7 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke7.addColorStop(0, '#0dcaf0');
            gradientStroke7.addColorStop(1, '#0dcaf0');

            var gradientStroke8 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke8.addColorStop(0, '#607d8b');
            gradientStroke8.addColorStop(1, '#607d8b');

            var gradientStroke9 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke9.addColorStop(0, '#0d6efd');
            gradientStroke9.addColorStop(1, '#0d6efd');

            var inspectorates = [];
            var inspectorateNumberOfLessons = [];
            $.each(inspectorateStatistics, function(key, value) {
                inspectorates.push(value.designation);
                inspectorateNumberOfLessons.push(value.number_of_lessons);
            });

            var myChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: inspectorates,
                    datasets: [{
                        backgroundColor: [
                            gradientStroke1,
                            gradientStroke2,
                            gradientStroke3,
                            gradientStroke4,
                            gradientStroke5,
                            gradientStroke6,
                            gradientStroke7,
                            gradientStroke8,
                            gradientStroke9,
                        ],
                        hoverBackgroundColor: [
                            gradientStroke1,
                            gradientStroke2,
                            gradientStroke3,
                            gradientStroke4,
                            gradientStroke5,
                            gradientStroke6,
                            gradientStroke7,
                            gradientStroke8,
                            gradientStroke9,
                        ],
                        data: inspectorateNumberOfLessons,
                        borderWidth: [1, 1, 1, 1, 1, 1, 1, 1, 1]
                    }]
                },
                options: {
                    maintainAspectRatio: false,
                    cutoutPercentage: 75,
                    legend: {
                        position: 'bottom',
                        display: false,
                        labels: {
                            boxWidth:8
                        }
                    },
                    tooltips: {
                        displayColors:false,
                    }
                }
            });

            // worl map
            jQuery('#geographic-map-2').vectorMap(
                {
                    map: 'world_mill_en',
                    backgroundColor: 'transparent',
                    borderColor: '#818181',
                    borderOpacity: 0.25,
                    borderWidth: 1,
                    zoomOnScroll: false,
                    color: '#009efb',
                    regionStyle : {
                        initial : {
                            fill : '#008cff'
                        }
                    },
                    markerStyle: {
                        initial: {
                            r: 9,
                            'fill': '#fff',
                            'fill-opacity':1,
                            'stroke': '#000',
                            'stroke-width' : 5,
                            'stroke-opacity': 0.4
                        },
                    },
                    enableZoom: true,
                    hoverColor: '#009efb',
                    markers : [{
                        latLng : [21.00, 78.00],
                        name : 'Lorem Ipsum Dollar'

                    }],
                    hoverOpacity: null,
                    normalizeFunction: 'linear',
                    scaleColors: ['#b6d6ff', '#005ace'],
                    selectedColor: '#c9dfaf',
                    selectedRegions: [],
                    showTooltip: true,
                })

            // Create the chart
            Highcharts.chart('inspectorateStatistics', {
                chart: {
                    type: 'column',
                    styledMode: true
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: '<?php echo __("messages.general_statistics"); ?>'
                },
                accessibility: {
                    announceNewData: {
                        enabled: true
                    }
                },
                xAxis: {
                    type: 'category'
                },
                yAxis: {
                    title: {
                        text: '<?php echo __("messages.total_number_of_lessons_produced") ?>'
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        borderWidth: 0,
                        dataLabels: {
                            enabled: true,
                            format: '{point.y}'
                        }
                    }
                },
                tooltip: {
                    headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                    pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y}</b> <?php echo __('messages.lessons') ?><br/>'
                },
                series: [{
                    name: "",
                    colorByPoint: true,
                    data: [{
                        name: "General Education",
                        y: <?php echo number_format($lessonStatistics["general_education"], 0, '.', ','); ?>,
                    },  {
                        name: "Enseignement Général",
                        y: <?php echo number_format($lessonStatistics["enseignement_general"], 0, '.', ','); ?>,
                    }, {
                        name: "Technical Education",
                        y: <?php echo number_format($lessonStatistics["technical_education"], 0, '.', ','); ?>,
                    }, {
                        name: "Enseignement Technique",
                        y: <?php echo number_format($lessonStatistics["enseignement_technique"], 0, '.', ','); ?>,
                    }, {
                        name: "Teacher Training",
                        y: <?php echo number_format($lessonStatistics["teacher_training"], 0, '.', ','); ?>,
                    }, {
                        name: "Enseignement Normal",
                        y: <?php echo number_format($lessonStatistics["enseignement_Normal"], 0, '.',','); ?>,
                    }]
                }],
            });

        })()
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.inspectorate.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minesec/public_html/dev.minesec.online/resources/views/inspectorate/dashboard.blade.php ENDPATH**/ ?>