
<?php $__env->startSection('title',  __('messages.edit_personnel')); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

            <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row">
                <div class="col-xl-9 mx-auto">
                    <ol class="breadcrumb mb-0 p-0">
                        <h6 class="mb-0 text-uppercase"><?php echo e(__("messages.inspectorate")); ?></h6>
                    </ol>
                    <hr/>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="p-4 border rounded">
                        <form enctype="multipart/form-data" action="<?php echo e(route("inspectorate.updatePersonnel")); ?>" method="post" class="row g-4 needs-validation" novalidate>

                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="id" value="<?php echo e($personnel->{"id"}); ?>">
                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Role</label>
                                <select class="form-select" name="role" id="validationCustom04" required>
                                    <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                    <?php $__currentLoopData = $inspectorateRoles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inspectorateRole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($inspectorateRole->{"name"}); ?>"
                                        <?php if($personnel->getRoleNames()[0] == $inspectorateRole->{"name"}): ?>
                                            <?php echo e("selected"); ?>

                                            <?php endif; ?>
                                        ><?php echo e($inspectorateRole->{"name"}); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom01" class="form-label">First name</label>
                                <input type="text" name="first_name" value="<?php echo e($personnel->{"first_name"}); ?>" class="form-control" id="validationCustom01" required>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom02" class="form-label">Last name</label>
                                <input type="text" name="last_name" value="<?php echo e($personnel->{"last_name"}); ?>" class="form-control" id="validationCustom02" required>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Gender</label>
                                <select class="form-select" name="gender" id="validationCustom04" required>
                                    <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                    <?php $__currentLoopData = $genders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"
                                        <?php if($personnel->{"gender"} == $key): ?>
                                            <?php echo e("selected"); ?>

                                            <?php endif; ?>
                                        ><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Language</label>
                                <select class="form-select" name="locale" name="<?php echo e(old("locale")); ?>" id="validationCustom04" required>
                                    <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"
                                        <?php if($personnel->{"locale"} == $key): ?>
                                            <?php echo e("selected"); ?>

                                        <?php endif; ?>
                                        ><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom03" class="form-label">Phone number</label>
                                <input type="text" name="phone_number" value="<?php echo e($personnel->{"phone_number"}); ?>" class="form-control" id="validationCustom03" required>
                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">New Password</label>
                                <input type="password" name="password" class="form-control" id="validationCustom05" >
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">Confirm New Password</label>
                                <input type="password" name="confirm_password" class="form-control" id="validationCustom05" >
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">Profile picture</label>
                                <input type="file" name="profile_picture" class="form-control" id="validationCustom05">
                            </div>

                            <div class="col-12">
                                <button class="btn btn-primary float-end" type="submit"><?php echo e(__("messages.save")); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/inspectorate/personnel/edit.blade.php ENDPATH**/ ?>