
<?php $__env->startSection('title', sprintf('%s - %s', __('messages.edit_term'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

        <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.edit_term")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="<?php echo e(route("term.update")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($term->{"id"}); ?>" />
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.term")); ?></label>
                                                <input type="text" value="<?php echo e($term->{"designation"}); ?>" name="designation" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(__("messages.classes")); ?></th>
                                                <th><?php echo e(__("messages.terms")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $term->{"id"} ?></td>
                                                    <td><?php echo $term->{"designation"} ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("term.edit", $term->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-term_id="<?php echo e($term->{"id"}); ?>" data-term_name="<?php echo e($term->{"designation"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

            <?php echo $__env->make("admin.term.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentTermId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentTermId = $(this).data('term_id');
                let term_name = $(this).data('term_name');
                $("#term_name").html(term_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentTermId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("term.delete")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentTermId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("term.index")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/term/edit.blade.php ENDPATH**/ ?>