
<?php $__env->startSection('title', sprintf('%s - %s', __('messages.personnel'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

            <div class="row">
                <div class="col-xl-9 mx-auto">
                    <ol class="breadcrumb mb-0 p-0">
                        <h6 class="mb-0 text-uppercase"><?php echo e(__("messages.personnel")); ?></h6>
                    </ol>
                    <hr/>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="personnelTable" class="table table-striped table-bordered">
                            <thead>
                            <tr>
                                <th>Inspectorate</th>
                                <th>Name</th>
                                <th>Phone Number</th>
                                <th>Role</th>
                                <th>Language</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $personnels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $personnel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($personnel->{"inspectorate"}->{"designation"}); ?></td>
                                    <td><?php echo e($personnel->{"first_name"}." ".$personnel->{"last_name"}); ?></td>
                                    <td><?php echo e($personnel->{"phone_number"}); ?></td>
                                    <td><?php echo e($personnel->getRoleNames()[0]); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($personnel->{"locale"} == $key): ?>
                                               <?php echo e($value); ?>

                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td><span <?php if ($personnel->{"blocked_at"} == null) { echo "class='badge bg-success'"; } else { echo "class='badge bg-danger'"; } ?>><?php echo e($personnel->{"blocked_at"} == null ? __("messages.active") : __("messages.blocked")); ?></span></td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="<?php echo e(route("inspectorate.editPersonnel", $personnel->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                            &nbsp; &nbsp;
                                            <a href="#" class="bx bx-block ms-3 show-block-modal"  data-personnel_id="<?php echo e($personnel->{"id"}); ?>" data-personnel_name="<?php echo e($personnel->{"first_name"}." ".$personnel->{"last_name"}); ?>" title="<?php echo e(__("messages.block_user")); ?>"></a>
                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-personnel_id="<?php echo e($personnel->{"id"}); ?>" data-personnel_name="<?php echo e($personnel->{"first_name"}." ".$personnel->{"last_name"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <?php echo $__env->make("admin.inspectorate.personnel.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make("admin.inspectorate.personnel.block_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentPersonnelId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentPersonnelId = $(this).data('personnel_id');
                let personnel_name = $(this).data('personnel_name');
                $("#personnel_name").html(personnel_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentPersonnelId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("inspectorate.deletePersonnel")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentPersonnelId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("inspectorate.indexPersonnel")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });


            let currentBlockPersonnelId = null;
            let blockModal = $('#blockModal');

            $(document).on('click','.show-block-modal',function(e) {
                currentBlockPersonnelId = $(this).data('personnel_id');
                let bloc_personnel_name = $(this).data('personnel_name');
                $("#bloc_personnel_name").html(bloc_personnel_name);

                $('#blockModal').modal('show');
            });

            blockModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentBlockPersonnelId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("inspectorate.blockPersonnel")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentBlockPersonnelId,
                        },
                        beforeSend: function(){
                            $('#server_response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            console.log(data)
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#server_response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#server_response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("inspectorate.indexPersonnel")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });
        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('#personnelTable').DataTable({
                // lengthChange: true,
                buttons: ['copy', 'excel', 'pdf', 'print']
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/Admin/inspectorate/personnel/list.blade.php ENDPATH**/ ?>