<?php $__env->startSection('title', sprintf('%s - %s', __('messages.digitisation_follow_up'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.digitisation_follow_up")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="row">
                <div class="col-xl-12 mx-auto">
                    <form class="needs-validation" novalidate enctype="multipart/form-data" action="<?php echo e(route("inspectorate.digitisation-planning")); ?>" method="post">
                        <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <!-- School Start  -->
                                <div class="col-md-2 p-3">
                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.school_year")); ?></label> </B>
                                    <select class="form-select" id="session_id" name="session_id" required >
                                        <option value=""><?php echo e(__("messages.select")); ?></option>
                                        <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($session->{"id"}); ?>"><?php echo e($session->{"designation"}); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.region")); ?></label> </B>
                                    <select class="form-select" id="region_id" name="region_id" required >
                                        <option value=""><?php echo e(__("messages.select")); ?></option>
                                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($region->{"id"}); ?>"><?php echo e($region->{"designation"}); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.division")); ?></label> </B>
                                    <select required id="division_id" name="division_id" class="form-control form-select"></select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-4 p-3">
                                    <B> <label class="form-label"><?php echo e(__("messages.name_of_school")); ?> </label></B>
                                    <div class="input-group"><button class="btn btn-outline-secondary" type="button"><i class='bx bx-search'></i></button>
                                        <select class="form-select single-select" id="school_id" name="school_id" aria-label="Example select with button addon">
                                            <option value=""><?php echo e(__("messages.select")); ?></option>
                                            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($school->{"id"}); ?>"><?php echo e($school->{"designation"}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                    </div>
                                </div>
                                <!-- School End  -->


                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label> </B>
                                    <select class="form-select" id="sub_system_id" name="sub_system_id" required >
                                        <option value=""><?php echo e(__("messages.select")); ?></option>
                                        <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subSystem->{"id"}); ?>"><?php echo e($subSystem->{"designation"}); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B><label for="education_type_id" class="form-label"><?php echo e(__("messages.education_type")); ?></label></B>
                                    <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="subEducationTypeInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.sub_education_type")); ?></label></B>
                                    <select class="form-select" id="sub_education_type_id" name="sub_education_type_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="specialtyInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.specialty")); ?></label></B>
                                    <select class="form-select" id="specialty_id" name="specialty_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="specialtyClassInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                    <select class="form-select" id="specialty_class_id" name="specialty_class_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="levelInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.level")); ?></label></B>
                                    <select class="form-select" id="level_id" name="level_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="levelClassInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                    <select class="form-select" id="level_class_id" name="level_class_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="classInput">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                    <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-3 p-3" id="classSubjects">
                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.subject")); ?></label></B>
                                    <select class="form-select" id="subject_id_to_digitise" name="subject_id_to_digitise" required aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="col-md-4 p-3" id="digitisationStage">
                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.stage")); ?></label> </B>
                                    <select class="form-select" id="stage" name="stage" required >
                                        <option value=""><?php echo e(__("messages.select")); ?></option>
                                        <?php $__currentLoopData = $digitisationStages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                </div>

                                <div class="row" id="lessonsToDigitise">
                                    <h6 class="modal-title"><?php echo e(__("messages.lessons")); ?></h6>
                                    <div class="col-md-12 lessons_to_digitise">
                                    </div>
                                </div>

                                <div class="row" id="lessonsDigitised">
                                    <h6 class="modal-title"><?php echo e(__("messages.lessons")); ?></h6>
                                    <div class="col-md-12 lessons_digitised">
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div id="success"></div>

                                <div id="save-button">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__("messages.save")); ?></button>
                                </div>

                                <div id="loader" class="visible">
                                    <button class="btn btn-primary " type="button"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span><?php echo e(__("messages.loading")); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
    <!--end page wrapper -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script src="<?php echo e(asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom/jquery.form.js')); ?>"></script>
    <script>
        $("#loader").css("display", "none");
        $("#save-button").css("display", "none");
        $(function () {
            $(document).ready(function () {
                $('form').ajaxForm({
                    beforeSend: function () {
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $('#success').empty();
                    },
                    uploadProgress: function () {
                        $("#session_id").prop("disabled", true);
                        $("#region_id").prop("disabled", true);
                        $("#division_id").prop("disabled", true);
                        $("#school_id").prop("disabled", true);
                        $("#sub_system_id").prop("disabled", true);
                        $("#education_type_id").prop("disabled", true);
                        $("#class_id").prop("disabled", true);
                        $("#sub_education_type_id").prop("disabled", true);
                        $("#level_id").prop("disabled", true);
                        $("#level_class_id").prop("disabled", true);
                        $("#specialty_id").prop("disabled", true);
                        $("#specialty_class_id").prop("disabled", true);
                        $("#subject_id_to_digitise").prop("disabled", true);
                        $("#stage").prop("disabled", true);

                        $("#lessonTitleIds").prop("disabled", true);

                        $(':input[type="button"]').prop('disabled', true);
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                    },

                    complete: function (data) {
                        if(data.responseJSON.error)
                        {
                            $("#loader").hide();
                            $("#save-button").css("display", "block");
                            $('#success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            window.setTimeout(function(){location.reload()},3000)
                        }

                        if(data.responseJSON.success)
                        {
                            $("#sub_system_id").prop("disabled", true);
                            $("#education_type_id").prop("disabled", true);
                            $("#class_id").prop("disabled", true);
                            $("#sub_education_type_id").prop("disabled", true);
                            $("#levelInput").prop("disabled", true);
                            $("#levelClassInput").prop("disabled", true);
                            $("#specialty_id").prop("disabled", true);
                            $("#specialty_class_id").prop("disabled", true);
                            $("#term_id").prop("disabled", true);
                            $("#subject_id").prop("disabled", true);
                            $("#upload_type").prop("disabled", true);
                            $("#showUploadField").prop("disabled", true);
                            $("#youtube_lesson_link").prop("disabled", true);
                            $("#video-field").prop("disabled", true);
                            $(':input[type="button"]').prop('disabled', true);
                            $('#success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $("#loader").hide();
                            $("#save-button").hide();
                            $("#cancel-button").hide();

                            window.setTimeout(function(){location.reload()},3000)
                        }
                    }
                });
            });
        });

        $('.multiple-select').select2({
            theme: 'bootstrap4',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $('.single-select').select2({
            theme: 'bootstrap4',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $('#region_id').change(function() {
            var regionID = $(this).val();
            if (regionID) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('get-divisions')); ?>?region_id=" + regionID,
                    success: function(data) {
                        if (data) {
                            $("#division_id").empty();
                            $("#division_id").append('<option><?php echo e(__("messages.select")); ?></option>');
                            $.each(data, function(key, value) {
                                $("#division_id").append('<option value="' + value.id +' ">' + value.designation +'</option>');
                            });
                        } else {
                            $("#division_id").empty();
                        }
                    }
                });
            } else {
                $("#division_id").empty();
                $("#sub_division_id").empty();
            }
        });

    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')
            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.inspectorate.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minesec/public_html/dev.minesec.online/resources/views/inspectorate/digitalisation/index.blade.php ENDPATH**/ ?>