<?php

use App\Http\Controllers\Web\Admin\ClassController;
use App\Http\Controllers\Web\Admin\DashboardController;
use App\Http\Controllers\Web\Admin\EducationTypeController;
use App\Http\Controllers\Web\Admin\InspectorateController;
use App\Http\Controllers\Web\Admin\LanguageController;
use App\Http\Controllers\Web\Admin\LessonController;
use App\Http\Controllers\Web\Admin\LessonTitleController;
use App\Http\Controllers\Web\Admin\LevelController;
use App\Http\Controllers\Web\Admin\RevisionController;
use App\Http\Controllers\Web\Admin\RolePermissionController;
use App\Http\Controllers\Web\Admin\SchoolController;
use App\Http\Controllers\Web\Admin\SpecialtyController;
use App\Http\Controllers\Web\Admin\SubEducationTypeController;
use App\Http\Controllers\Web\Admin\SubjectController;
use App\Http\Controllers\Web\Admin\SubSystemController;
use App\Http\Controllers\Web\Admin\TermController;
use App\Http\Controllers\Web\Auth\AuthenticationController;
use App\Http\Controllers\Web\HomeController;
use App\Http\Controllers\Web\Inspectorate\DigitisationController;
use App\Http\Controllers\Web\Inspectorate\InspectorateDashboardController;
use App\Http\Controllers\Web\Inspectorate\InspectorateLessonController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('progression-sheet', [HomeController::class, 'progression'])->name('progression');
Route::match(['GET', 'POST'], 'data-collection', [HomeController::class, 'dataCollection'])->name('data-collection');
Route::get('e-library', [HomeController::class, "eLibrary"])->name('e_library');
Route::get('product-details', [HomeController::class, "productDetails"])->name('product-details');
Route::get('pay', [HomeController::class, 'pay'])->name("pay");

Route::get('get-education-type', [EducationTypeController::class, 'getEducationTypes'])->name('home.education-type.get');
Route::get('get-sub-education', [SubEducationTypeController::class, 'getSubEducationTypes'])->name('home.sub-education-type.get');
Route::get('get-levels', [LevelController::class, 'getLevels'])->name('home.levels.get');
Route::get('get-level-classes', [ClassController::class, 'getLevelClasses'])->name('home.level-classes.get');
Route::get('get-specialties', [SpecialtyController::class, 'getSpecialties'])->name('home.specialty.get');
Route::get('get-classes', [ClassController::class, 'getClasses'])->name('home.class.get');
Route::get('get-specialty-classes', [ClassController::class, 'getSpecialtyClasses'])->name('home.class.get-specialty-classes');
Route::post('class-subjects', [SubjectController::class, 'getClassSubjects'])->name('home.get-class-subjects');
Route::get('get-sub-system-subjects', [SubjectController::class, 'getSubSystemSubjects'])->name('home.subject.get-sub-system-subjects');
Route::post('class/subject', [LessonController::class, 'getSubjectLessons'])->name('home.lessons.get-subject-lessons');


/**
 * Auth
 */
Route::get('login', [AuthenticationController::class, 'auth'])->name('login');
Route::post('authentication', [AuthenticationController::class, 'authentication'])->name('authentication');
Route::get('logout', [AuthenticationController::class, 'logout'])->name('logout');


Route::middleware('auth')->group(function () {

    /**
     * Localization
     */
    Route::post('language', [LanguageController::class, 'changeLanguage'])->name('changLanguage');


    Route::group(['prefix' => 'admin'], function () {


        Route::get('data-collection', [HomeController::class, "dataCollectionOne"])->name('data-collection_one');


        /**
         * Dashboard
         */
        Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');

        /**
         * Get divisions and subdivisions
         */
        Route::get('get-divisions', [DigitisationController::class, 'getDivisions'])->name('get-divisions');

        /**
         * Get classes and sub education types
         */
        Route::get('get-sub-system', [SubSystemController::class, 'getSubjectGroupSubsystem'])->name('sub-system.get');
        Route::get('get-education-type', [EducationTypeController::class, 'getEducationTypes'])->name('education-type.get');
        Route::get('get-classes', [ClassController::class, 'getClasses'])->name('class.get');
        Route::get('get-sub-education', [SubEducationTypeController::class, 'getSubEducationTypes'])->name('sub-education-type.get');
        Route::get('get-levels', [LevelController::class, 'getLevels'])->name('levels.get');
        Route::get('get-level-classes', [ClassController::class, 'getLevelClasses'])->name('level-classes.get');
        Route::get('get-specialties', [SpecialtyController::class, 'getSpecialties'])->name('specialty.get');
        Route::get('get-specialty-classes', [ClassController::class, 'getSpecialtyClasses'])->name('class.get-specialty-classes');
        Route::get('get-sub-system-subjects', [SubjectController::class, 'getSubSystemSubjects'])->name('subject.get-sub-system-subjects');
        Route::post('get-selected-sub-system-subjects', [SubjectController::class, 'getSelectedSubSystemSubjects'])->name('subject.get-selected-sub-system-subjects');

        /**
         * Sub system
         */
        Route::prefix('sub-system')->group(function () {
            Route::get('/', [SubSystemController::class, 'index'])->name('sub-system.index');
            Route::post('create', [SubSystemController::class, 'create'])->name('sub-system.create');
            Route::get('edit/{id}', [SubSystemController::class, 'edit'])->name('sub-system.edit');
            Route::post('update', [SubSystemController::class, 'update'])->name('sub-system.update');
            Route::post('delete', [SubSystemController::class, 'delete'])->name('sub-system.delete');
        });

        /**
         * Education type
         */
        Route::prefix('education-type')->group(function () {
            Route::get('/', [EducationTypeController::class, 'index'])->name('education-type.index');
            Route::post('create', [EducationTypeController::class, 'create'])->name('education-type.create');
            Route::get('edit/{id}', [EducationTypeController::class, 'edit'])->name('education-type.edit');
            Route::post('update', [EducationTypeController::class, 'update'])->name('education-type.update');
            Route::post('delete', [EducationTypeController::class, 'delete'])->name('education-type.delete');
        });

        /**
         * Sub education type
         */
        Route::prefix('sub-education-type')->group(function () {
            Route::get('/', [SubEducationTypeController::class, 'index'])->name('sub-education-type.index');
            Route::post('create', [SubEducationTypeController::class, 'create'])->name('sub-education-type.create');
            Route::get('edit/{id}', [SubEducationTypeController::class, 'edit'])->name('sub-education-type.edit');
            Route::post('update', [SubEducationTypeController::class, 'update'])->name('sub-education-type.update');
            Route::post('delete', [SubEducationTypeController::class, 'delete'])->name('sub-education-type.delete');
        });

        /**
         * Specialties
         */
        Route::prefix('specialty')->group(function () {
            Route::get('/', [SpecialtyController::class, 'index'])->name('specialty.index');
            Route::post('create', [SpecialtyController::class, 'create'])->name('specialty.create');
            Route::get('edit/{id}', [SpecialtyController::class, 'edit'])->name('specialty.edit');
            Route::post('update', [SpecialtyController::class, 'update'])->name('specialty.update');
            Route::post('delete', [SpecialtyController::class, 'delete'])->name('specialty.delete');
        });

        /**
         * Levels
         */
        Route::prefix('levels')->group(function () {
            Route::get('/', [LevelController::class, 'index'])->name('level.index');
            Route::post('create', [LevelController::class, 'create'])->name('level.create');
            Route::get('edit/{id}', [LevelController::class, 'edit'])->name('level.edit');
            Route::post('update', [LevelController::class, 'update'])->name('level.update');
            Route::post('delete', [LevelController::class, 'delete'])->name('level.delete');
        });

        /**
         * Classes
         */
        Route::prefix('classes')->group(function () {
            Route::get('/', [ClassController::class, 'index'])->name('class.index');
            Route::post('create', [ClassController::class, 'create'])->name('class.create');
            Route::get('edit/{id}', [ClassController::class, 'edit'])->name('class.edit');
            Route::post('update', [ClassController::class, 'update'])->name('class.update');
            Route::post('delete', [ClassController::class, 'delete'])->name('class.delete');
        });

        /**
         * Terms
         */
        Route::prefix('terms')->group(function () {
            Route::get('/', [TermController::class, 'index'])->name('term.index');
            Route::post('create', [TermController::class, 'create'])->name('term.create');
            Route::get('edit/{id}', [TermController::class, 'edit'])->name('term.edit');
            Route::post('update', [TermController::class, 'update'])->name('term.update');
            Route::post('delete', [TermController::class, 'delete'])->name('term.delete');
        });

        /**
         * Revisions
         */
        Route::prefix('revisions')->group(function () {
            Route::get('/', [RevisionController::class, 'index'])->name('revision.index');
            Route::post('create', [RevisionController::class, 'create'])->name('revision.create');
            Route::get('edit/{id}', [RevisionController::class, 'edit'])->name('revision.edit');
            Route::post('update', [RevisionController::class, 'update'])->name('revision.update');
            Route::post('delete', [RevisionController::class, 'delete'])->name('revision.delete');
        });

        /**
         * Lessons
         */
        Route::prefix('lessons')->group(function () {
            Route::get('/', [LessonController::class, 'index'])->name('lesson.index');
            Route::post('create', [LessonController::class, 'create'])->name('lesson.create');
            Route::get('edit/{id}', [LessonController::class, 'edit'])->name('lesson.edit');
            Route::get('delete/{id}', [LessonController::class, 'delete'])->name('lesson.delete');

            Route::prefix('validation')->group(function () {
                Route::get('/', [LessonController::class, 'lessons'])->name('lesson.validation-index');
                Route::get('show-lesson/{id}', [LessonController::class, 'showLesson'])->name('lessons.validation.show');
                Route::post('update-lesson', [LessonController::class, 'updateLesson'])->name('lessons.validation.update');
                Route::post('delete-lesson', [LessonController::class, 'deleteLesson'])->name('lesson.validation.delete');
                Route::post('approve', [LessonController::class, 'approveSubmission'])->name('lessons.validation.approve');
                Route::post('reject', [LessonController::class, 'rejectSubmission'])->name('lessons.validation.reject');
            });

            Route::prefix('recording')->group(function () {
                Route::get('/', [LessonController::class, 'approvedLessons'])->name('lesson.recording-index');
                Route::get('show-lesson/{id}', [LessonController::class, 'showApprovedLesson'])->name('lessons.recording.show');
                Route::post('approve', [LessonController::class, 'approveValidatedLesson'])->name('lessons.recording.approve');
                Route::post('reject', [LessonController::class, 'rejectedValidatedLesson'])->name('lessons.recording.reject');
            });

            Route::prefix('editing')->group(function () {
                Route::get('/', [LessonController::class, 'recordedLessons'])->name('lesson.editing-index');
                Route::get('show-lesson/{id}', [LessonController::class, 'showRecordedLesson'])->name('lessons.editing.show');
                Route::post('approve', [LessonController::class, 'approveRecordedLesson'])->name('lessons.editing.approve');
                Route::post('reject', [LessonController::class, 'rejectedRecordedLesson'])->name('lessons.editing.reject');
            });

            Route::prefix('segmenting')->group(function () {
                Route::get('/', [LessonController::class, 'editedLessons'])->name('lesson.segmenting-index');
                Route::get('show-lesson/{id}', [LessonController::class, 'showEditedLesson'])->name('lessons.segmenting.show');
                Route::post('approve', [LessonController::class, 'approveEditedLesson'])->name('lessons.segmenting.approve');
                Route::post('reject', [LessonController::class, 'rejectedEditedLesson'])->name('lessons.segmenting.reject');
            });

            Route::prefix('put-in-class')->group(function () {
                Route::get('/', [LessonController::class, 'segmentedLessons'])->name('lesson.put-in-class-index');
                Route::get('show-lesson/{id}', [LessonController::class, 'showSegmentedLesson'])->name('lessons.put-in-class.show');
                Route::post('approve', [LessonController::class, 'putSegmentedLessonInClass'])->name('lessons.put-in-class.approve');
                Route::post('reject', [LessonController::class, 'rejectSegmentedLesson'])->name('lessons.put-in-class.reject');
            });

        });

        /**
         * Subjects
         */
        Route::prefix('subjects')->group(function () {
            Route::get('/', [SubjectController::class, 'index'])->name('subject.index');
            Route::post('create', [SubjectController::class, 'create'])->name('subject.create');
            Route::get('edit/{id}', [SubjectController::class, 'edit'])->name('subject.edit');
            Route::post('update', [SubjectController::class, 'update'])->name('subject.update');
            Route::post('delete', [SubjectController::class, 'delete'])->name('subject.delete');
            Route::get('class-subjects', [SubjectController::class, 'getSubjectGroupClassSubject'])->name('subject.subject-group-subject');

            //Aub system Subjects
            Route::prefix('sub-systems')->group(function () {
                Route::get('subjects', [SubjectController::class, 'subSystemSubjects'])->name('subject.subSystem-subjects');
                Route::post('creat-subject', [SubjectController::class, 'createSubSystemSubjects'])->name('subject.create-subSystem-subject');
                Route::get('edit-subject/{id}', [SubjectController::class, 'editSubSystemSubject'])->name('subject.edit-subSystem-subject');
                Route::post('update-subject', [SubjectController::class, 'updateSubSystemSubject'])->name('subject.update-SubSystem-subject');
                Route::post('delete-subject', [SubjectController::class, 'deleteSubSystemSubject'])->name('subject.delete-subSystem-subject');
            });

            //Class Subjects
            Route::prefix('classes')->group(function () {
                Route::get('', [SubjectController::class, 'ClassSubjects'])->name('subject.class-subject');
                Route::post('create-subject', [SubjectController::class, 'createClassSubject'])->name('subject.create-class-subject');
                Route::get('edit-subject/{id}', [SubjectController::class, 'editClassSubject'])->name('subject.edit-class-subject');
                Route::post('update-subject', [SubjectController::class, 'updateClassSubject'])->name('subject.update-class-subject');
                Route::post('delete-subject', [SubjectController::class, 'deleteCLassSubject'])->name('subject.delete-class-subject');
            });

            //Subject Lessons
            Route::prefix('lessons')->group(function () {
                Route::get('', [LessonTitleController::class, 'index'])->name('subject.lesson-title');
                Route::post('creat', [LessonTitleController::class, 'create'])->name('subject.lesson-title.create');
                Route::post('titles', [LessonTitleController::class, 'getLessonTitles'])->name('subject.get-lesson-titles');
            });

        });

        /**
         * Inspectorates
         */
        Route::prefix('inspectorates')->group(function () {
            Route::get('/', [InspectorateController::class, 'index'])->name('inspectorate.index');
            Route::post('create', [InspectorateController::class, 'create'])->name('inspectorate.create');
            Route::get('edit/{id}', [InspectorateController::class, 'edit'])->name('inspectorate.edit');
            Route::post('update', [InspectorateController::class, 'update'])->name('inspectorate.update');
            Route::post('delete', [InspectorateController::class, 'delete'])->name('inspectorate.delete');

            Route::prefix('personnel')->group(function () {
                Route::get('/', [InspectorateController::class, 'personnel'])->name('inspectorate.indexPersonnel');
                Route::get('add/{id}', [InspectorateController::class, 'createPersonnel'])->name('inspectorate.createPersonnel');
                Route::post('create', [InspectorateController::class, 'storePersonnel'])->name('inspectorate.storePersonnel');
                Route::get('edit/{id}', [InspectorateController::class, 'editPersonnel'])->name('inspectorate.editPersonnel');
                Route::post('update', [InspectorateController::class, 'updatePersonnel'])->name('inspectorate.updatePersonnel');
                Route::post('delete', [InspectorateController::class, 'deletePersonnel'])->name('inspectorate.deletePersonnel');
                Route::post('block', [InspectorateController::class, 'blockPersonnel'])->name('inspectorate.blockPersonnel');
                Route::post('unblock', [InspectorateController::class, 'unblockPersonnel'])->name('inspectorate.unblockPersonnel');
            });

            Route::prefix('subjects')->group(function () {
                Route::get('/', [InspectorateController::class, 'subjects'])->name('inspectorate.subjects');

            });

        });

        /**
         * Settings
         */
        Route::prefix('settings')->group(function () {

            Route::prefix('roles')->group(function () {
                Route::get('/', [RolePermissionController::class, 'index'])->name('role.index');
                Route::post("create", [RolePermissionController::class, 'create'])->name('role.create');
                Route::get('edit/{id}', [RolePermissionController::class, 'edit'])->name('role.edit');
                Route::post('update', [RolePermissionController::class, 'update'])->name('role.update');
                Route::post('delete', [RolePermissionController::class, 'delete'])->name('role.delete');
            });

            Route::prefix('permissions')->group(function () {
                Route::get('permission/{id}', [RolePermissionController::class, 'rolePermission'])->name('permission.assign-permission');
                Route::post('create', [RolePermissionController::class, 'assign'])->name('role-permission.create');
            });

        });

        /**
         * Lesson production
         */
        Route::prefix('lesson-production')->group(function () {
            // Route::post('pre-validate', )
        });

        /**
         * Schools
         */
        Route::prefix('schools')->group(function () {
            Route::post('import', [SchoolController::class, 'import'])->name('schools.import');
            Route::get('/', [SchoolController::class, 'index'])->name('schools.index');
            Route::post('create', [SchoolController::class, 'create'])->name('schools.create');
            Route::get('edit/{id}', [SchoolController::class, 'edit'])->name('schools.edit');
            Route::post('update', [SchoolController::class, 'update'])->name('schools.update');
            Route::post('delete', [SchoolController::class, 'delete'])->name('schools.delete');
        });

    });


    Route::group(['prefix' => 'inspectorate'], function () {
        Route::get('dashboard', [InspectorateDashboardController::class, 'index'])->name('inspectorate.dashboard');

        Route::prefix('lessons')->group(function () {
            Route::get('/', [InspectorateLessonController::class, 'lessons'])->name('inspectorate.lesson-validation');
            Route::post('add-lesson', [InspectorateLessonController::class, 'addLesson'])->name("inspectorate.add-lessons-validation");
        });

        Route::prefix('digitisation')->group(function (){
            Route::get('/', [DigitisationController::class, "index"])->name('inspectorate.digitisation');
            Route::post('planning', [DigitisationController::class, 'planning'])->name('inspectorate.digitisation-planning');
            Route::post('get-planned-lessons', [DigitisationController::class, 'getPlannedLessons'])->name('inspectorate.digitisation-planned-lessons');
            Route::post('implementation', [DigitisationController::class, 'implementation'])->name('inspectorate.digitisation-implementation');
        });
    });


});

