@extends("layouts.inspectorate.master")
@section('title', sprintf('%s - %s', __('messages.lessons_to_be_validated'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/input-tags/css/tagsinput.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" />
    <style>
        .progress {
            position:relative;
            width:100%;
        }
        .bar {
            background-color: #00ff00;
            width:0;
            height:20px;
        }
        .percent {
            position:absolute;
            display:inline-block;
            left:50%;
            color: #040608;
        }
    </style>
@endsection

@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.lessons_to_be_validated")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="card-body">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="{{__("messages.search")}}"> <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                        <div class="ms-auto"><button type="button" class="btn btn-primary radius-30 mt-2 mt-lg-0" data-bs-toggle="modal" data-bs-target="#submitLessonModal"><i class="bx bxs-plus-square"></i>{{__("messages.add_lesson_to_validate")}}</button></div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>{{__("messages.education_type")}}</th>
                                <th>{{__("messages.class")}}</th>
                                <th>{{__("messages.subject")}}</th>
                                <th>{{__("messages.title")}}</th>
                                <th>{{__("messages.status")}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($lessonProgressions as $lessonProgression)
                                <tr>
                                    <td><?php echo $lessonProgression->{'educationType'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'className'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'subject'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'lessonTitle'}->{'title'} ?></td>
                                    <td><span <?php
                                            $style = match ($lessonProgression->{"status"}) {
                                                config('minesec.validation_status.pending') => "class='badge bg-gradient-blooker text-white shadow-sm w-100'",

                                                config('minesec.validation_status.rejected'),
                                                config('minesec.validation_status.validation_rejected'),
                                                config('minesec.validation_status.recording_rejected'),
                                                config('minesec.validation_status.editing_rejected'),
                                                config('minesec.validation_status.segmentation_rejected'),
                                                => "class='badge bg-gradient-bloody text-white shadow-sm w-100'",


                                                config('minesec.validation_status.validated'),
                                                config('minesec.validation_status.recorded'),
                                                config('minesec.validation_status.edited'),
                                                config('minesec.validation_status.segmented'),
                                                config('minesec.validation_status.put_in_claas'),
                                                => "class='badge bg-gradient-quepal text-white shadow-sm w-100'",
                                                default => null,
                                            };

                                            echo $style;

                                            ?>><?php echo  $lessonProgression->{"status"} ?></span></td>
                                    <td>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Modal -->
                    <form class="needs-validation" novalidate enctype="multipart/form-data" action="{{route("inspectorate.add-lessons-validation")}}" method="post">
                        @csrf
                        <div class="modal fade" id="submitLessonModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog  modal-xl modal-dialog-scrollable">
                                <div class="modal-content">

                                    <div class="modal-header">
                                        <h5 class="modal-title">{{__("messages.add_lesson_to_validate")}}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>

                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label">{{__("messages.inspectorate")}}</label>
                                                <select class="form-select" id="inspectorate_id" name="inspectorate_id" readonly="" required> <option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($inspectorates as $inspectorate)
                                                        <option value="{{$inspectorate->{"id"} }}"
                                                        @if($inspectorate->{"id"} == session("inspectorate_id"))
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$inspectorate->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label">{{__("messages.sub_systems")}}</label>
                                                <select class="form-select" id="sub_system_id" name="sub_system_id" required> <option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($subSystems as $subSystem)
                                                        <option value="{{$subSystem->{"id"} }}">{{$subSystem->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.education_type")}}</label>
                                                <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="classInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.sub_education_type")}}</label>
                                                <select class="form-select" id="sub_education_type_id" name="sub_education_type_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.specialty")}}</label>
                                                <select class="form-select" id="specialty_id" name="specialty_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="specialtyClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="specialty_class_id" name="specialty_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="levelInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.level")}}</label>
                                                <select class="form-select" id="level_id" name="level_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="levelClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="level_class_id" name="level_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                        </div>

                                        <hr/>
                                        <div class="col-md-3" id="classSubjects">
                                            <h6><label for="validationTooltip01" class="form-label">{{__("messages.subjects")}}</label></h6>
                                            <select class="form-select" id="subject_id" name="subject_id"  aria-label="select example">
                                            </select>
                                            <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                        </div>

                                        <hr/>
                                        <div class="row" id="LessonTitles">
                                            <h6 class="modal-title">{{__("messages.lessons")}}</h6>
                                            <div class="col-md-12 lesson_titles">
                                            </div>
                                        </div>

                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.powerpoint")}}</label>
                                                <input type="file" class="form-control" name="lesson_power_point" id="lesson-field" aria-label="file example" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                                <hr/>
                                                <div class="progress">
                                                    <div class="bar"></div >
                                                    <div class="percent">0%</div >
                                                </div>
                                                <hr/>
                                                <div id="success"></div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <div id="cancel-button">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__("messages.close")}}</button>
                                        </div>

                                        <div id="save-button">
                                            <button type="submit" class="btn btn-primary">{{__("messages.save")}}</button>
                                        </div>

                                        <div id="loader" class="visible">
                                            <button class="btn btn-primary" type="button" > <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>{{__("messages.uploading")}}</button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>


        </div>
    </div>
    <!--end page wrapper -->
@endsection

@section("script")
    <script src="{{asset('assets/plugins/input-tags/js/tagsinput.js')}}"></script>
{{--    <script src="{{asset('assets/js/custom/jquery.mini.js')}}"></script>--}}
    <script src="{{asset('assets/js/custom/jquery.form.js')}}"></script>
    <script>
        $(document).ready(function() {
            let currentLevelId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentLevelId = $(this).data('level_id');
                let level_name = $(this).data('level_name');
                $("#level_name").html(level_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentLevelId !== null) {
                    $.ajax({
                        url: "{{route("lesson.validation.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentLevelId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("lesson.validation-index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });
        });
    </script>

    <script type="text/javascript">
        $(function () {
            $('#inspectorate_id').prop('disabled',false);

            $(document).ready(function () {
                var bar = $('.bar');
                var percent = $('.percent');
                $('form').ajaxForm({
                    beforeSend: function () {
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = '0%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                        $('#success').empty();
                    },
                    uploadProgress: function (event, position, total, percentComplete) {
                        $("#sub_system_id").prop("disabled", true);
                        $("#education_type_id").prop("disabled", true);
                        $("#class_id").prop("disabled", true);
                        $("#sub_education_type_id").prop("disabled", true);
                        $("#level_id").prop("disabled", true);
                        $("#level_class_id").prop("disabled", true);
                        $("#specialty_id").prop("disabled", true);
                        $("#specialty_class_id").prop("disabled", true);
                        $("#inspectorate_id").prop("disabled", true);
                        $("#lesson-field").prop("disabled", true);
                        $(':input[type="button"]').prop('disabled', true);


                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = percentComplete + '%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                    },

                    complete: function (data) {

                        if(data.responseJSON.error)
                        {
                            $("#loader").hide();
                            $("#save-button").css("display", "block");
                            $("#cancel-button").css("display", "block");
                            $('#success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            window.setTimeout(function(){location.reload()},3000)
                        }
                        if(data.responseJSON.success)
                        {
                            $("#sub_system_id").prop("disabled", true);
                            $("#education_type_id").prop("disabled", true);
                            $("#class_id").prop("disabled", true);
                            $("#sub_education_type_id").prop("disabled", true);
                            $("#levelInput").prop("disabled", true);
                            $("#levelClassInput").prop("disabled", true);
                            $("#specialty_id").prop("disabled", true);
                            $("#specialty_class_id").prop("disabled", true);
                            $("#inspectorate_id").prop("disabled", true);
                            $("#lesson-field").prop("disabled", true);
                            $(':input[type="button"]').prop('disabled', true);
                            $('#success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $("#loader").hide();
                            $("#save-button").hide();
                            $("#cancel-button").hide();

                            window.setTimeout(function(){location.reload()},3000)
                        }
                    }
                });
            });
        });
    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
@endsection
