@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.edit_subject'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.edit_subject")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">

                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("subject.update")}}" method="POST">

                                            @csrf
                                            <input type="hidden" name="id" value="{{ $subject->{"id"} }}" />

                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label">{{__("messages.inspectorates")}}</label>
                                                <select class="form-select" id="inspectorate_id" name="inspectorate_id" required> <option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($inspectorates as $inspectorate)
                                                        <option value="{{$inspectorate->{"id"} }}"
                                                        @if($subject->{'inspectorate_id'} == $inspectorate->{"id"})
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$inspectorate->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.subject")}}</label>
                                                <input type="text" value="{{$subject->{"designation"} }}" name="designation" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="card-body">
                                                <div class="form-check form-check-inline">
                                                    <input type="radio" class="form-check-input" id="validationFormCheck3" name="type" value="{{config('minesec.subject_type.theory') }}"  @if( $subject->{"type"} == config('minesec.subject_type.theory')) checked @endif  required>
                                                    <label class="form-check-label" for="validationFormCheck3">{{__("messages.theory")}}</label>
                                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                                </div>

                                                <div class="form-check form-check-inline">
                                                    <input type="radio" class="form-check-input" id="validationFormCheck3" name="type" value="{{config('minesec.subject_type.practical') }}"  @if( $subject->{"type"} == config('minesec.subject_type.practical')) checked @endif  required>
                                                    <label class="form-check-label" for="validationFormCheck3">{{__("messages.practical")}}</label>
                                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__("messages.subjects")}}</th>
                                                <th>{{__("messages.type")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($subjects as $subject)
                                                <tr>
                                                    <td><?php echo $subject->{"id"} ?></td>
                                                    <td><?php echo $subject->{"designation"} ?></td>
                                                    <td><?php echo $subject->{"type"} ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("subject.edit", $subject->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-subject_id="{{$subject->{"id"} }}" data-subject_name="{{$subject->{"designation"} }}"  title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

           @include("admin.subject.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentSubjectId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentSubjectId = $(this).data('subject_id');
                let subject_name = $(this).data('subject_name');
                $("#subject_name").html(subject_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentSubjectId !== null) {
                    $.ajax({
                        url: "{{route("subject.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentSubjectId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("subject.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
@endsection
