@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.assign_permissions'), __(config('app.name'))))

@section("style")
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.assign_permissions_to_role")}}</div>
            </div>
            <!--end breadcrumb-->
            <div class="card">
                <div class="card-body">
                    <div id="invoice">
                        <div class="invoice overflow-auto">
                            <div style="min-width: 600px">
                                <main>
                                    <form action="{{route("role-permission.create")}}" method="post">
                                        @csrf
                                        <input type="hidden" name="role_id" value="{{$role->{"id"} }}">
                                        <div class="row contacts">
                                            <div class="col invoice-to">
                                                <h4 class="to">{{__("messages.assign_permission_to")}}: {{$role->{"name"} }} </h4>
                                            </div>
                                        </div>
                                        <table>
                                            <thead>
                                            <tr>
                                                <th>{{__("messages.module")}}</th>
                                                <th class="text-left">{{__("messages.feature")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($permissionGroups as $permissionGroup)
                                                <tr>
                                                    <td class="no">{{$permissionGroup["designation"] }}</td>

                                                    <td class="text-left">
                                                        @foreach($permissionGroup["permission_Categories"] as $permissionCategory)
                                                        <h6>{{$permissionCategory["designation"] }}</h6>
                                                    @foreach($permissionCategory->{"permissions"} as $permission)
                                                                <div class="form-check form-check-right">
                                                                    <input class="form-check-input" type="checkbox" name="permissionIds[]" value="{{$permission->{"id"} }}"
                                                                    @foreach ($roleHasPermissions as $roleHasPermission)
                                                                        {{ $roleHasPermission->{"permission_id"} == $permission->{"id"} ? 'checked' : '' }}
                                                                        @endforeach
                                                                    ><label class="font-size-16 text-muted mb-0 float-none">{{$permission->{"name"} }} </label>
                                                                </div>
                                                        @endforeach
                                                        @endforeach
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    <div class="col-12">
                                                        <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                                    </div></td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </form>
                                </main>
                            </div>
                            <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                            <div></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentTermId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentTermId = $(this).data('term_id');
                let term_name = $(this).data('term_name');
                $("#term_name").html(term_name);
                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();
                if(currentTermId !== null) {
                    $.ajax({
                        url: "{{route("term.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentTermId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("term.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endsection
