@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.roless'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

        <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.add_role")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("role.create")}}" method="POST">
                                            @csrf
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.role")}}</label>
                                                <input type="text" value="{{ old('name') }}" name="name" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__("messages.roless")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($roles as $role)
                                                <tr>
                                                    <td><?php echo $role->{"id"} ?></td>
                                                    <td><?php echo $role->{"name"} ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("role.edit", $role->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            &nbsp; &nbsp;
                                                            <a href="{{route("permission.assign-permission", $role->{"id"}) }}" class="bx bxs-user-plus" title="{{__("messages.assign_permissions")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-role_id="{{$role->{"id"} }}" data-role_name="{{$role->{"name"} }}"  title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </div>

            @include("admin.settings.role_permission.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentRoleId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentRoleId = $(this).data('role_id');
                let role_name = $(this).data('role_name');
                $("#role_name").html(role_name);
                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();
                if(currentRoleId !== null) {
                    $.ajax({
                        url: "{{route("role.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentRoleId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("role.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
@endsection
