@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.lessons_to_be_validated'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/input-tags/css/tagsinput.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" />
    <style>
        .progress {
            position:relative;
            width:100%;
        }
        .bar {
            background-color: #00ff00;
            width:0;
            height:20px;
        }
        .percent {
            position:absolute;
            display:inline-block;
            left:50%;
            color: #040608;
        }
    </style>
@endsection

@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.lessons_to_be_validated")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="card-body">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="{{__("messages.search")}}"> <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>{{__("messages.education_type")}}</th>
                                <th>{{__("messages.class")}}</th>
                                <th>{{__("messages.subject")}}</th>
                                <th>{{__("messages.title")}}</th>
                                <th>{{__("messages.status")}}</th>
                                <th>{{__("messages.action")}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($lessonProgressions as $lessonProgression)
                                <tr>
                                    <td><?php echo $lessonProgression->{'educationType'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'className'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'subject'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'lessonTitle'}->{'title'} ?></td>
                                    <td><span <?php
                                            $style = match ($lessonProgression->{"status"}) {
                                                config('minesec.validation_status.pending') => "class='badge bg-gradient-blooker text-white shadow-sm w-100'",

                                                config('minesec.validation_status.rejected'),
                                                config('minesec.validation_status.validation_rejected'),
                                                config('minesec.validation_status.recording_rejected'),
                                                config('minesec.validation_status.editing_rejected'),
                                                config('minesec.validation_status.segmentation_rejected'),
                                                => "class='badge bg-gradient-bloody text-white shadow-sm w-100'",


                                                config('minesec.validation_status.validated'),
                                                config('minesec.validation_status.recorded'),
                                                config('minesec.validation_status.edited'),
                                                config('minesec.validation_status.segmented'),
                                                config('minesec.validation_status.put_in_claas'),
                                                => "class='badge bg-gradient-quepal text-white shadow-sm w-100'",
                                                default => null,
                                            };

                                            echo $style;

                                            ?>><?php echo  $lessonProgression->{"status"} ?></span></td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{route("lessons.validation.show", $lessonProgression->{"id"}) }}" class=""><i class='lni lni-eye'></i></a>
                                            <a href="{{route("lesson.validation.delete", $lessonProgression->{"id"}) }}" class="ms-3"><i class='bx bxs-trash'></i></a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


        </div>
    </div>
    <!--end page wrapper -->
@endsection

@section("script")
    <script src="{{asset('assets/plugins/input-tags/js/tagsinput.js')}}"></script>
{{--    <script src="{{asset('assets/js/custom/jquery.mini.js')}}"></script>--}}
    <script src="{{asset('assets/js/custom/jquery.form.js')}}"></script>
    <script>
        $(document).ready(function() {
            let currentLevelId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentLevelId = $(this).data('level_id');
                let level_name = $(this).data('level_name');
                $("#level_name").html(level_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentLevelId !== null) {
                    $.ajax({
                        url: "{{route("lesson.validation.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentLevelId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("lesson.validation-index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });
        });
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
@endsection
