@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.recording'), __(config('app.name'))))

@section("style")
@endsection

@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.recording")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="card-body">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="{{__("messages.search")}}"> <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>{{__("messages.education_type")}}</th>
                                <th>{{__("messages.class")}}</th>
                                <th>{{__("messages.subject")}}</th>
                                <th>{{__("messages.title")}}</th>
                                <th>{{__("messages.status")}}</th>
                                <th>{{__("messages.action")}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($lessonProgressions as $lessonProgression)
                                <tr>
                                    <td><?php echo $lessonProgression->{'educationType'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'className'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'subject'}->{'designation'} ?></td>
                                    <td><?php echo $lessonProgression->{'lessonTitle'}->{'title'} ?></td>
                                    <td><span <?php
                                            $style = match ($lessonProgression->{"status"}) {
                                                config('minesec.validation_status.pending') => "class='badge bg-gradient-blooker text-white shadow-sm w-100'",

                                                config('minesec.validation_status.rejected'),
                                                config('minesec.validation_status.validation_rejected'),
                                                config('minesec.validation_status.recording_rejected'),
                                                config('minesec.validation_status.editing_rejected'),
                                                config('minesec.validation_status.segmentation_rejected'),
                                                => "class='badge bg-gradient-bloody text-white shadow-sm w-100'",


                                                config('minesec.validation_status.validated'),
                                                config('minesec.validation_status.recorded'),
                                                config('minesec.validation_status.edited'),
                                                config('minesec.validation_status.segmented'),
                                                config('minesec.validation_status.put_in_claas'),
                                                => "class='badge bg-gradient-quepal text-white shadow-sm w-100'",
                                                default => null,
                                            };

                                            echo $style;
                                            ?>><?php echo  $lessonProgression->{"status"} ?></span></td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{route("lessons.recording.show", $lessonProgression->{"id"}) }}" class=""><i class='lni lni-eye'></i></a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!--end page wrapper -->
@endsection

@section("script")
@endsection
