@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.lessons'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/input-tags/css/tagsinput.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" />
    <style>
        .progress {
            position:relative;
            width:100%;
        }
        .bar {
            background-color: #00ff00;
            width:0;
            height:20px;
        }
        .percent {
            position:absolute;
            display:inline-block;
            left:50%;
            color: #040608;
        }
    </style>
@endsection

@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.lessons")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="card-body">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="{{__("messages.search")}}"> <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                        <div class="ms-auto"><button type="button" class="btn btn-primary radius-30 mt-2 mt-lg-0" data-bs-toggle="modal" data-bs-target="#lessonModal"><i class="bx bxs-plus-square"></i>{{__("messages.add_lesson")}}</button></div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                            <tr>
                                <th>{{__("messages.class")}}</th>
                                <th>{{__("messages.subject")}}</th>
                                <th>{{__("messages.title")}}</th>
                                <th>{{__("messages.description")}}</th>
                                <th>Total</th>
                                <th>View Details</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($lessons as $lesson)
                                <tr>
                                    <td><?php echo $lesson->{'className'}->{'designation'} ?></td>
                                    <td><?php echo $lesson->{'subject'}->{'designation'} ?></td>
                                    <td><?php echo $lesson->{'lessonTitle'}->{'title'} ?></td>
                                    <td><?php echo $lesson->{'lessonTitle'}->{'description'} ?></td>
                                    <td><div class="badge rounded-pill text-success bg-light-success p-2 text-uppercase px-3"><i class='bx bxs-circle me-1'></i>30</div></td>
                                    <td><button type="button" class="btn btn-primary btn-sm radius-30 px-4">View Details</button></td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="#" class=""><i class='bx bxs-edit'></i></a>
                                            <a href="{{route("lesson.delete", $lesson->{"id"}) }}" class="ms-3"><i class='bx bxs-trash'></i></a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Modal -->
                    <form class="needs-validation" novalidate enctype="multipart/form-data" action="{{route("lesson.create")}}" method="post">
                        @csrf
                        <div class="modal fade" id="lessonModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog  modal-xl modal-dialog-scrollable">
                                <div class="modal-content">

                                    <div class="modal-header">
                                        <h5 class="modal-title">{{__("messages.add_lesson")}}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>

                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label">{{__("messages.sub_systems")}}</label>
                                                <select class="form-select" id="sub_system_id" name="sub_system_id" required><option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($subSystems as $subSystem)
                                                        <option value="{{$subSystem->{"id"} }}">{{$subSystem->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.education_type")}}</label>
                                                <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="classInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.sub_education_type")}}</label>
                                                <select class="form-select" id="sub_education_type_id" name="sub_education_type_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.specialty")}}</label>
                                                <select class="form-select" id="specialty_id" name="specialty_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="specialtyClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="specialty_class_id" name="specialty_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="levelInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.level")}}</label>
                                                <select class="form-select" id="level_id" name="level_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3" id="levelClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="level_class_id" name="level_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label">{{__("messages.term")}}</label>
                                                <select class="form-select" id="term_id" name="term_id" required> <option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($terms as $term)
                                                        <option value="{{$term->{"id"} }}">{{$term->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                        </div>

{{--                                        <hr/>--}}
{{--                                        <h6 class="modal-title">{{__("messages.classes")}}</h6>--}}
{{--                                        <div class="row" id="classInput">--}}
{{--                                            <div class="col-md-3 class_checkbox">--}}
{{--                                            <div class="invalid-feedback">{{__("error.filed_required")}}</div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

{{--                                        <div class="row" id="specialtyClassInput">--}}
{{--                                            <div class="col-md-3 specialtyClass_checkbox">--}}
{{--                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

{{--                                        <div class="row" id="levelClassInput">--}}
{{--                                            <div class="col-md-3 levelClass_checkbox">--}}
{{--                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

                                        <hr/>
                                        <div class="col-md-3" id="classSubjects">
                                            <h6><label for="validationTooltip01" class="form-label">{{__("messages.subjects")}}</label></h6>
                                            <select class="form-select" id="subject_id" name="subject_id"  aria-label="select example">
                                            </select>
                                            <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                        </div>

                                        <hr/>
                                        <div class="row" id="LessonTitles">
                                            <h6 class="modal-title">{{__("messages.lessons")}}</h6>
                                            <div class="col-md-12 lesson_titles">
                                            </div>
                                        </div>

                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-check form-switch float-start">
                                                    <label class="form-check-label" for="flexSwitchCheckDefault">{{__("messages.upload_file")}}
                                                        <input class="form-check-input" type="checkbox" name="upload_file" id="showUploadField" value="yes" {{ old('upload_file') ? 'checked' : null }} onchange="switchView()">
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <hr/>
                                        <span id="lessonUpload">
                                            <div class="col-md-3">
                                                    <label for="validationCustom04" class="form-label">{{__("messages.upload_type")}}</label>
                                                    <select class="form-select" id="upload_type" name="upload_type"> <option selected disabled value="">{{__("messages.select")}}</option>
                                                        @foreach($resourceDestination as $key => $vale)
                                                            <option value="{{$key }}">{{$vale }}</option>
                                                        @endforeach
                                                    </select>
                                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                                </div>

                                                <hr/>
                                            <div class="row form-group" id="destinationLocalServer">

                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label">{{__("messages.video")}}</label>
                                                <input type="file" class="form-control" name="lesson_video" id="video-field" aria-label="file example">
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                                <hr/>
                                                <div class="progress">
                                                    <div class="bar"></div>
                                                    <div class="percent">0%</div >
                                                </div>
                                            </div>
                                             <div id="success"></div>
                                        </div>

                                             <div class="row form-group" id="destinationYouTube">
                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label">{{__("messages.you_tube_link")}}</label>
                                                <input type="url" class="form-control" name="youtube_lesson_link" id="youtube_lesson_link">
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div id="you_tube_success"></div>
                                        </div>
                                        </span>

                                        <span id="fileUpload">
                                            <div>
                                                 <input type="file" name="lessons" class="form-control" />
                                            </div>
                                            <div id="file_import_success"></div>
                                        </span>
                                    </div>

                                    <div class="modal-footer">
                                        <div id="cancel-button">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__("messages.close")}}</button>
                                        </div>

                                        <div id="save-button">
                                            <button type="submit" class="btn btn-primary">{{__("messages.save")}}</button>
                                        </div>

                                        <div id="loader" class="visible">
                                            <button class="btn btn-primary " type="button"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>{{__("messages.uploading")}}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>
    </div>
    <!--end page wrapper -->
@endsection

@section("script")
    <script src="{{asset('assets/plugins/input-tags/js/tagsinput.js')}}"></script>
    <script src="{{asset('assets/js/custom/jquery.form.js')}}"></script>
    <script>
        $('#fileUpload').css('display', 'none'); // Show the text input box in default
        $('#lessonUpload').css('display', 'block'); // Hide the text input box in default
        function switchView() {
            if ($('#showUploadField').prop('checked')) {
                $('#fileUpload').css('display', 'block');
                $('#lessonUpload').css('display', 'none');
            } else {
                $('#fileUpload').css('display', 'none');
                $('#lessonUpload').css('display', 'block');
            }
        }

        $('#destinationLocalServer').css('display', 'none'); // Show the text input box in default
        $('#destinationYouTube').css('display', 'none'); // Hide the text input box in default
        $(document).on('change', '#upload_type', function (e) {
            const upload_type = $('#upload_type').val();
            if(upload_type == 'local_server') {
                $('#destinationLocalServer').css('display', 'block');
                $('#destinationYouTube').css('display', 'none');
            } else  {
                $('#destinationLocalServer').css('display', 'none');
                $('#destinationYouTube').css('display', 'block');
            }
        });

        $(function () {
            $(document).ready(function () {
                var bar = $('.bar');
                var percent = $('.percent');
                $('form').ajaxForm({
                    beforeSend: function () {
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = '0%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                        $('#success').empty();
                        $('#you_tube_success').empty();
                        $('#file_import_success').empty();
                    },
                    uploadProgress: function (event, position, total, percentComplete) {
                        $("#sub_system_id").prop("disabled", true);
                        $("#education_type_id").prop("disabled", true);
                        $("#class_id").prop("disabled", true);
                        $("#sub_education_type_id").prop("disabled", true);
                        $("#level_id").prop("disabled", true);
                        $("#level_class_id").prop("disabled", true);
                        $("#specialty_id").prop("disabled", true);
                        $("#specialty_class_id").prop("disabled", true);
                        $("#term_id").prop("disabled", true);
                        $("#subject_id").prop("disabled", true);
                        $("#upload_type").prop("disabled", true);
                        $("#showUploadField").prop("disabled", true);
                        $("#youtube_lesson_link").prop("disabled", true);
                        $("#video-field").prop("disabled", true);
                        $(':input[type="button"]').prop('disabled', true);


                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = percentComplete + '%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                    },

                    complete: function (data) {
                        if(data.responseJSON.error)
                        {
                            $("#loader").hide();
                            $("#save-button").css("display", "block");
                            $("#cancel-button").css("display", "block");
                            $('#success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            $('#you_tube_success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            $('#file_import_success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            window.setTimeout(function(){location.reload()},3000)
                        }

                        if(data.responseJSON.success)
                        {
                            $("#sub_system_id").prop("disabled", true);
                            $("#education_type_id").prop("disabled", true);
                            $("#class_id").prop("disabled", true);
                            $("#sub_education_type_id").prop("disabled", true);
                            $("#levelInput").prop("disabled", true);
                            $("#levelClassInput").prop("disabled", true);
                            $("#specialty_id").prop("disabled", true);
                            $("#specialty_class_id").prop("disabled", true);
                            $("#term_id").prop("disabled", true);
                            $("#subject_id").prop("disabled", true);
                            $("#upload_type").prop("disabled", true);
                            $("#showUploadField").prop("disabled", true);
                            $("#youtube_lesson_link").prop("disabled", true);
                            $("#video-field").prop("disabled", true);
                            $(':input[type="button"]').prop('disabled', true);
                            $('#success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $('#you_tube_success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $('#file_import_success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $("#loader").hide();
                            $("#save-button").hide();
                            $("#cancel-button").hide();

                            window.setTimeout(function(){location.reload()},3000)
                        }
                    }
                });
            });
        });
    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')
            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endsection

