@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.inspectorate_subjects'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet"/>
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

        <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.inspectorate_subjects")}}</div>
            </div>


            <div class="container">
                <div class="main-body">
                    <div class="row">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="table table-striped table-bordered" style="width:100%">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>{{__("messages.inspectorate")}}</th>
                                            <th>{{__("messages.subjects")}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($inspectorates as $inspectorate)
                                            <tr>
                                                <td><?php echo $inspectorate->{"id"} ?></td>
                                                <td><?php echo $inspectorate->{"designation"} ?></td>
                                                <td>
                                                    @foreach($inspectorate->{"inspectorateSubjects"} as $subject)
                                                        <?php   echo "<div>" .$subject->{"designation"} . "</div>" ?>
                                                    @endforeach
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section("script")

@endsection
