@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.education_type'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet"/>
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.add_education_type")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate  action="{{route("education-type.create")}}" method="POST">
                                            @csrf
                                            <div class="col-md-12">
                                                <label for="validationCustom03"
                                                       class="form-label">{{__("messages.education_type")}}</label>
                                                <input type="text" value="{{ old('designation') }}" name="designation"
                                                       class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div>
                                                <div class="card-body">
                                                    <div class="form-check form-switch">
                                                        <label class="form-check-label" for="flexSwitchCheckDefault">{{__("messages.for_technical")}}
                                                            <input class="form-check-input" type="checkbox" name="type"  id="showField" value="yes" {{ old('showField') ? 'checked' : null }} onchange="myFunction()">
                                                        </label>
                                                    </div>

                                                    <div class="form-check form-switch">
                                                        <label class="form-check-label" for="flexSwitchCheckChecked">{{__("messages.for_teacher_training")}}</label>
                                                        <input class="form-check-input" type="checkbox" name="type_1" id="levels" value="yes" {{ old('showField') ? 'checked' : null }} onchange="myFunction()">
                                                    </div>
                                                </div>
                                            </div>

                                            <div>
                                                <span id="subEducationTypeField">
                                                    <h6 class="mb-0">{{__("messages.sub_education_type")}}</h6>
                                                    <div class="card-body">
                                                    @foreach($subEducationTypes as $subEducationType)
                                                            <div class="form-check">
                                                        <label class="form-check-label" for="flexCheckChecked"> <input
                                                                class="form-check-input" type="checkbox"
                                                                name="subEducationTypeIds[]"
                                                                value="<?php echo $subEducationType->{"id"} ?>"
                                                                {{ (is_array(old('subEducationTypeIds')) && in_array($subEducationType->{"id"}, old('subEducationTypeIds'))) ? ' checked' : '' }} id="flexCheckChecked"> <?php echo $subEducationType->{"designation"} ?> </label>
                                                    </div>
                                                        @endforeach
                                                </div>
                                                </span>
                                            </div>

                                            <div>
                                                <span id="levelTypeField">
                                                    <h6 class="mb-0">{{__("messages.levels")}}</h6>
                                                    <div class="card-body">
                                                    @foreach($levels as $level)
                                                            <div class="form-check">
                                                        <label class="form-check-label" for="flexCheckChecked"> <input
                                                                class="form-check-input" type="checkbox"
                                                                name="levelIds[]"
                                                                value="<?php echo $level->{"id"} ?>"
                                                                {{ (is_array(old('levelIds')) && in_array($level->{"id"}, old('levelIds'))) ? ' checked' : '' }} id="flexCheckChecked"> <?php echo $level->{"designation"} ?> </label>
                                                    </div>
                                                        @endforeach
                                                </div>
                                                </span>
                                            </div>

                                            <div>
                                                     <span id="classField">
                                                <h6 class="mb-0">{{__("messages.class")}}</h6>
                                                <div class="card-body">
                                                    @foreach($classes as $class)
                                                        <div class="form-check">
                                                        <label class="form-check-label" for="flexCheckChecked"> <input
                                                                class="form-check-input" type="checkbox"
                                                                name="classIds[]" value="<?php echo $class->{"id"} ?>"
                                                                {{ (is_array(old('classIds')) && in_array($class->{"id"}, old('classIds'))) ? ' checked' : '' }} id="flexCheckChecked"> <?php echo $class->{"designation"} ?> </label>
                                                    </div>
                                                    @endforeach
                                                </div>
                                                     </span>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right"
                                                        type="submit">{{__("messages.save")}}</button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__("messages.education_type")}}</th>
                                                <th>{{__("messages.class")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($educationTypes as $educationType)
                                                <tr>
                                                    <td><?php echo $educationType->{"id"} ?></td>
                                                    <td><?php echo $educationType->{"designation"} ?></td>

                                                    @if($educationType->{"type"}  == config('minesec.education_type.general'))
                                                    <td>
                                                        @foreach($educationType->{"classes"} as $class)
                                                            <?php   echo "<div>" . $class->{"designation"} . "</div>" ?>
                                                        @endforeach
                                                    </td>
                                                    @endif

                                                    @if($educationType->{"type"} == config('minesec.education_type.technical'))
                                                        <td>
                                                            @foreach($educationType->{"subEducation"} as $subEducation)
                                                                <?php   echo "<div>" . $subEducation->{"designation"} . "</div>" ?>
                                                            @endforeach
                                                        </td>
                                                    @endif

                                                    @if($educationType->{"type"} == config('minesec.education_type.teacher_training'))
                                                        <td>
                                                            @foreach($educationType->{"levels"} as $level)
                                                                <?php   echo "<div>" . $level->{"designation"} . "</div>" ?>
                                                            @endforeach
                                                        </td>
                                                    @endif

                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("education-type.edit", $educationType->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-education_type_id="{{$educationType->{"id"} }}" data-education_type_name="{{$educationType->{"designation"} }}"  data-type="{{$educationType->{"type"} }}"  title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

       @include("admin.education_type.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentEducationTypeId = null;
            let currentType = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentEducationTypeId = $(this).data('education_type_id');
                currentType = $(this).data('type');
                let education_type_name = $(this).data('education_type_name');
                $("#education_type_name").html(education_type_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentEducationTypeId !== null) {
                    $.ajax({
                        url: "{{route("education-type.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentEducationTypeId,
                            type: currentType,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("education-type.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>

    <script>
        $('#subEducationTypeField').css('display', 'none'); // Hide the text input box in default
        $('#levelTypeField').css('display', 'none'); // Hide the text input box in default
        $('#classField').css('display', 'block'); // Show the text input box in default
        function myFunction() {
            if ($('#showField').prop('checked')) {
                $("#levels").prop("disabled", true);
                $('#subEducationTypeField').css('display', 'block');
                $('#levelTypeField').css('display', 'none');
                $('#classField').css('display', 'none');
            } else if($('#levels').prop('checked')) {
                $("#showField").prop("disabled", true);
                $('#subEducationTypeField').css('display', 'none');
                $('#levelTypeField').css('display', 'block');
                $('#classField').css('display', 'none');
            } else {
                $("#showField").prop("disabled", false);
                $("#levels").prop("disabled", false);
                $('#subEducationTypeField').css('display', 'none');
                $('#levelTypeField').css('display', 'none');
                $('#classField').css('display', 'block');
            }
        }
    </script>
@endsection
