<?php

namespace Database\Seeders;

use App\Models\Session;
use Illuminate\Database\Seeder;

class SessionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sessions = config('seeder.sessions');

        foreach ($sessions as $key => $session) {
            Session::factory()->create([
                "designation" => $session["designation"],
                "is_active" => $session["is_active"],
            ]);
        }
    }
}
