<?php

namespace Database\Seeders;

use App\Models\PermissionCategory;
use App\Models\PermissionGroup;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $permissionGroups = config("seeder.permission_group");

        foreach ($permissionGroups as $data) {

            $permissionGroup = PermissionGroup::factory()->create(["designation" => $data["designation"]]);

            foreach ($data["permission_category"] as  $category) {
                $permissionCategory = PermissionCategory::factory()->create([
                    "designation" => $category["designation"],
                    "permission_group_id" =>  $permissionGroup->{"id"},
                ]);

                foreach ($category["permissions"] as $permission) {
                    \App\Models\Permission::factory()->create([
                        "permission_category_id" => $permissionCategory->{"id"},
                        "feature" => $permission["feature"],
                        "name" => $permission["name"],
                        "guard_name" => $permission["guard_name"],
                    ]);
                }

            }
        }

        $defaultRoles = config("seeder.default_roles");
        foreach ($defaultRoles as $role) {
            \App\Models\Role::factory()->create([
                "role_name" => $role["role_name"],
                "name" => $role["name"],
                "guard_name" => $role["guard_name"],
                "is_system" => $role["is_system"],
            ]);
        }
    }
}
