<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lesson_progression_details', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('stage');
            $table->string('status');

            $table->bigInteger('lesson_progression_id')->unsigned();
            $table->foreign('lesson_progression_id')->references('id')->on('lesson_progressions')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('submitted_by')->unsigned();
            $table->foreign('submitted_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('submitted_at');
            $table->string('submitter_phone_number');

            $table->bigInteger('submission_validated_by')->unsigned()->nullable();
            $table->foreign('submission_validated_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('submission_validated_at')->nullable();
            $table->bigInteger('submission_rejected_by')->unsigned()->nullable();
            $table->foreign('submission_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('submission_rejected_at')->nullable();
            $table->string('submission_rejection_reason')->nullable();

            $table->bigInteger('validation_rejected_by')->unsigned()->nullable();
            $table->foreign('validation_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('validation_rejected_at')->nullable();
            $table->string('validation_rejection_reason')->nullable();

            $table->bigInteger('recorded_by')->unsigned()->nullable();
            $table->foreign('recorded_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('recorded_at')->nullable();
            $table->bigInteger('recording_rejected_by')->unsigned()->nullable();
            $table->foreign('recording_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('recording_rejected_at')->nullable();
            $table->string('recording_rejection_reason')->nullable();

            $table->bigInteger('edited_by')->unsigned()->nullable();
            $table->foreign('edited_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('edited_at')->nullable();
            $table->bigInteger('editing_rejected_by')->unsigned()->nullable();
            $table->foreign('editing_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('editing_rejected_at')->nullable();
            $table->string('editing_rejection_reason')->nullable();

            $table->bigInteger('segmented_by')->unsigned()->nullable();
            $table->foreign('segmented_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('segmented_at')->nullable();
            $table->bigInteger('segmentation_rejected_by')->unsigned()->nullable();
            $table->foreign('segmentation_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('segmentation_rejected_at')->nullable();
            $table->string('segmentation_rejection_reason')->nullable();

            $table->bigInteger('put_in_class_by')->unsigned()->nullable();
            $table->foreign('put_in_class_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('put_in_class_at')->nullable();
            $table->bigInteger('put_in_class_rejected_by')->unsigned()->nullable();
            $table->foreign('put_in_class_rejected_by')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamp('put_in_class_rejected_at')->nullable();
            $table->string('put_in_class_rejection_reason')->nullable();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lesson_progression_details');
    }
};
