<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_system_education_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('sub_system_id')->unsigned();
            $table->foreign('sub_system_id')->references('id')->on('sub_systems')->onUpdate('cascade')->onDelete('cascade');
            $table->bigInteger('education_type_id')->unsigned();
            $table->foreign('education_type_id')->references('id')->on('education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_system_education_types');
    }
};
