<?php

namespace App\Services;

use App\Models\Subject;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\HigherOrderBuilderProxy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\HigherOrderCollectionProxy;

trait SubjectService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Subject::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**'
     * Get all subjects
     *
     * @return Builder[]|Collection
     */
    public  static function allSubjects(): Collection|array
    {

        return Subject::query()->get();
    }

    /**
     * FInd subject by id
     *
     * @param $id
     * @return Model|Builder|null
     */
    public static function findById($id): Model|Builder|null
    {
        return Subject::query()->where('id', $id)->first();
    }

    /**
     * Create subject
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function createSubject(array $data): Model|Builder
    {
        return self::store([
            "inspectorate_id" => $data["inspectorate_id"],
            "designation" => $data["designation"],
            "type" => $data["type"],
        ]);
    }

    /**
     * Update class with given id
     *
     * @param array $data
     * @return int|null
     */
    public static function updateSubject(array $data): ?int
    {
        try {
            $subject = Subject::query()->where('id', $data["id"])->update(['inspectorate_id' => $data["inspectorate_id"], 'designation' => $data["designation"], 'type' => $data["type"]]);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'updateSubject::createRegion');
            $subject = null;
        }

        return $subject;
    }

    /**
     * Delete class with given id
     *
     * @param $id
     * @return int|null
     */
    public  static function deleteSubject($id): ?int
    {
        try {
            $subject = Subject::destroy($id);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'deleteSubject::createRegion');
            $subject = null;
        }

        return $subject;
    }

    /**
     * Get inspectorate id
     *
     * @param int $subjectId
     * @return mixed
     */
    public static function getSubjectInspectorateId(int $subjectId): mixed
    {
        $subject = Subject::query()->find($subjectId);

        return $subject->{"inspectorate_id"};
    }
}
