<?php

namespace App\Services;

use App\Models\Revision;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait RevisionService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Revision::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all revisions
     *
     * @return Builder[]|Collection
     */
    public static function allRevisions(): Collection|array
    {
        return Revision::query()->get();
    }

    /**
     * Find by id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return Revision::query()->find($id);
    }

    /**
     * Create revision
     *
     * @param array $data
     * @return Builder|Model|null
     */
    public static function createRevision(array $data): Model|Builder|null
    {
        try {

            $revision = self::store([
                "sub_system_id" => $data["sub_system"],
                "subject_id" => $data["subject_id"],
                "exam" => $data["exam"],
                "topic" => $data["topic"],
                "link" => $data["link"],
                "studio" => $data["studio"],
                "start_time" => $data["start_time"],
                "end_time" => $data["end_time"],
                "date" => $data["date"],
            ]);

            $results = $revision;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'RevisionService::createRevision');
            $results = null;
        }

        return $results;
    }

    /**
     * Update revision
     *
     * @param array $data
     * @return Revision|null
     */
    public function UpdateRevision(array $data): ?Revision
    {
        try {
            $revision = $this;

            $revision->updateService([
                "sub_system_id" => $data["sub_system"],
                "subject_id" => $data["subject_id"],
                "exam" => $data["exam"],
                "topic" => $data["topic"],
                "link" => $data["link"],
                "studio" => $data["studio"],
                "start_time" => $data["start_time"],
                "end_time" => $data["end_time"],
                "date" => $data["date"],
            ]);

            $results = $revision;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'RevisionService::UpdateRevision');
            $results = null;
        }
        return $results;
    }

    /**
     * Delete revision
     *
     * @return Revision
     */
    public function deleteRevision(): Revision
    {
        try {
            $revision = $this;
            $revision->delete();
        } catch (\Exception $exception) {
            log_debug($exception, "RevisionService::deleteRevision");
            $revision = null;
        }

        return $revision;
    }


}
