<?php

namespace App\Services;

use App\Models\PermissionGroup;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait PermissionGroupService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return PermissionGroup::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all permission groups
     *
     * @return array
     */
    public static function allPermissionGroups(): array
    {
        $permissionGroups = PermissionGroup::query()->with("permissionCategory")->get();

        $permissionGroupResults = array();

        foreach ($permissionGroups as $permissionGroup) {
            $permissionGroupResults[] = array(
                "id" => $permissionGroup->{"id"},
                "designation" => $permissionGroup->{"designation"},
                "permission_Categories" => $permissionGroup->{"permissionCategory"},
            );
        }

        return $permissionGroupResults;
    }
}
