<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class UserRules
{
    /**
     * FInd rule
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function findUser($id): array
    {
        return [
            "id" => "required|integer|exists:users",
        ];
    }

    /**
     * Delete user
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function deleteUser(): array
    {
        return [
            "id" => "required|integer|exists:users",
        ];
    }

    /**
     * Block user
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function blockUser(): array
    {
        return [
            "id" => "required|integer|exists:users",
        ];
    }
}
