<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class TermRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:50",
        ];
    }


    /**
     * Edit rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public  static  function edit($id): array
    {
        return [
            "id" => "required|integer|exists:terms",
        ];
    }


    /**
     * Update rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string"])] public static  function update(): array
    {
        return [
            "id" => "required|integer|exists:terms",
            "designation" => "required|max:50",
        ];
    }


    /**
     * Delete rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:terms",
        ];
    }
}
