<?php

namespace App\RequestRules\Web;


use JetBrains\PhpStorm\ArrayShape;

class SubjectRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "type" => "string", "inspectorate_id" => "string"])] public static function create(): array
    {
        $baseRules = [
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['subjects' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                [
                    "designation" => "required|max:50",
                    "type" => "required|max:10",
                ]
            );
        }

        return $baseRules;
    }


    /**
     * Edit rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:subjects",
        ];
    }


    /**
     * Update rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "type" => "string", "inspectorate_id" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:subjects",
            "designation" => "required|max:50",
            "type" => "required|max:10",
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
        ];
    }


    /**
     * Delete
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:subjects",
        ];
    }

    /**
     * Create or update sub system subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["sub_system_id" => "string", "subjectIds" => "string"])] public static function createOrUpdateSubSystemSubjects(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }

    /**
     * Edit system subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function editSubSystemSubjects($id): array
    {
        return [
            "id" => "required|integer|exists:sub_systems",
        ];
    }

    /**
     * Delete system subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function deleteSubSystemSubjects(): array
    {
        return [
            "id" => "required|integer|exists:sub_systems",
        ];
    }

    /**
     * Get sub system subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["sub_system_id" => "string"])] public static function getSubSystemSubjects(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
        ];
    }

    /**
     * Get selected sub system rules
     *
     * @return string[]
     */
    #[ArrayShape(["sub_system_id" => "string", "subject_group_id" => "string"])] public static function getSelectedSubSystemSubjects(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "subject_group_id" => "required|integer|exists:subject_groups,id",
        ];
    }


    /**
     * Create class subject for general education rule
     *
     * @return string[]
     */
    #[ArrayShape(["designation" => "string", "sub_system_id" => "string", "class_id" => "string", "subjectIds" => "string"])] public static function createClassSubjectGeneralEducation(): array
    {
        return [
            "designation" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }

    /**
     * Update class subject for general education rule
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string", "designation" => "string", "sub_system" => "string", "class_id" => "string", "subjectIds" => "string"])] public static function updateClassSubjectGeneralEducation(): array
    {
        return [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "designation" => "required|max:50",
            "sub_system" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }


    /**
     * Create class subject for technical education rule
     *
     * @return string[]
     */
    #[ArrayShape(["designation" => "string", "sub_system_id" => "string", "sub_education_type_id" => "string", "specialty_id" => "string", "specialty_class_id" => "string", "subjectIds" => "string"])] public static function createClassSubjectTechnicalEducation(): array
    {
        return [
            "designation" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }


    /**
     * Update class subject for technical education rules
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string", "designation" => "string", "sub_system" => "string", "sub_education_type" => "string", "specialty" => "string", "specialty_class" => "string", "subjectIds" => "string"])] public static function updateClassSubjectTechnicalEducation(): array
    {
        return [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "designation" => "required|max:50",
            "sub_system" => "required|integer|exists:sub_systems,id",
            "sub_education_type" => "required|integer|exists:sub_education_types,id",
            "specialty" => "required|integer|exists:specialties,id",
            "specialty_class" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }

    /**
     * Create class subject for teacher training rule
     *
     * @return string[]
     */
    #[ArrayShape(["designation" => "string", "sub_system_id" => "string", "level_id" => "string", "level_class_id" => "string", "subjectIds" => "string"])] public static function createClassSubjectTeacherTraining(): array
    {
        return [
            "designation" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }

    /**
     * Update class subject for teacher training rule
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string", "designation" => "string", "sub_system" => "string", "level" => "string", "level_class" => "string", "subjectIds" => "string"])] public static function updateClassSubjectTeacherTraining(): array
    {
        return [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "designation" => "required|max:50",
            "sub_system" => "required|integer|exists:sub_systems,id",
            "level" => "required|integer|exists:levels,id",
            "level_class" => "required|integer|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
        ];
    }

    /**
     * Edit class subject
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function editClassSubjects($id): array
    {
        return [
            "id" => "required|integer|exists:subject_groups",
        ];
    }

    /**
     * Delete class subject group rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function deleteClassSubject(): array
    {
        return [
            "id" => "required|integer|exists:subject_groups",
        ];
    }

    /**
     * Get general education class subjects rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "education_type_id" => "string", "class_id" => "string"])] public static function getGeneralEducationClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "education_type_id" => "required|integer|exists:education_types,id",
            "class_id" => "required|integer|exists:classes,id",
        ];
    }

    /**
     * Get technical education class subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "specialty_id" => "string", "specialty_class_id" => "string"])] public static function getTechnicalEducationClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
        ];
    }

    /**
     * Get teacher training class subject rules
     *
     * @return string[]
     */
    #[ArrayShape(["type" => "string", "level_id" => "string", "level_class_id" => "string"])] public static function getTeacherTrainingClassSubjects(): array
    {
        return [
            "type" => "required|max:5",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
        ];
    }

    /**
     * Get subject group subjects
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string"])] public static function getSubjectGroupSubjects(): array
    {
        return [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
        ];
    }

}
