<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class SubEducationTypeRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "specialtyIds" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:50",
            "specialtyIds" => "required|array|exists:specialties,id",
        ];
    }

    /** Edit rule
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:sub_education_types",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "specialtyIds" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:sub_education_types",
            "designation" => "required|max:50",
            "specialtyIds" => "required|array|exists:specialties,id",
        ];
    }

    /**
     *  Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:sub_education_types",
        ];
    }

    /**
     * Get sub education type rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getSubEducationTypes(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }
}
