<?php

namespace App\RequestRules\Web;

class RolePermissionRules
{
    /**
     * Create role rule
     *
     * @return string[]
     */
    public static function createRole(): array
    {
        return [
            "name" => "required|string",
        ];
    }

    /**
     * Edit rule
     *
     * @param $id
     * @return string[]
     */
    public static function edit($id): array
    {
        return [
            "id" => "required|numeric|exists:roles,id",
        ];
    }

    /**
     * Update role rule
     *
     * @return string[]
     */
    public static function update(): array
    {
        return [
            "role_id" => "required|numeric|exists:roles,id",
            "name" => "required|string",
        ];
    }

    /**
     * Delete role rule
     *
     * @return string[]
     */
    public static function delete(): array
    {
        return [
            "id" => "required|numeric|exists:roles,id",
        ];
    }

    /**
     * Get all roles
     *
     * @param $id
     * @return string[]
     */
    public static function getPermissions($id): array
    {
        return [
            "id" => "required|numeric|exists:roles,id",
        ];
    }

    /**
     * Create role/permission rules
     *
     * @return string[]
     */
    public static function assignPermissionsToRoles(): array
    {
        return [
            "role_id" => "required|numeric|exists:roles,id",
            "permissionIds" => "required|array|exists:permissions,id",
        ];
    }

}
