<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class LessonProgressionRules
{
    /**
     * Submit general education lesson rules
     *
     * @return string[]
     */
 #[ArrayShape(["inspectorate_id" => "string", "sub_system_id" => "string", "class_id" => "string", "subject_id" => "string", "lesson_title_id" => "string", 'lesson_power_point' => "string"])] public static function submitGeneralEducationLesson(): array
    {
        return [
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "lesson_title_id" => "required|integer|exists:lesson_titles,id",
            'lesson_power_point' => 'required|file',
        ];
    }

    /**
     * Submit technical education lesson rules
     *
     * @return string[]
     */
 #[ArrayShape(["inspectorate_id" => "string", "sub_system_id" => "string", "sub_education_type_id" => "string", "specialty_id" => "string", "specialty_class_id" => "string", "subject_id" => "string", "lesson_title_id" => "string", 'lesson_power_point' => "string"])] public static function submitTechnicalEducationLesson(): array
    {
        return [
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "lesson_title_id" => "required|integer|exists:lesson_titles,id",
            'lesson_power_point' => 'required|file',
        ];
    }

    /**
     * Submit teacher training lesson rules
     *
     * @return string[]
     */
 #[ArrayShape(["inspectorate_id" => "string", "sub_system_id" => "string", "level_id" => "string", "level_class_id" => "string", "subject_id" => "string", "lesson_title_id" => "string", 'lesson_power_point' => "string"])] public static function submitTeacherTrainingLesson(): array
    {
        return [
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "lesson_title_id" => "required|integer|exists:lesson_titles,id",
            'lesson_power_point' => 'required|file',
        ];
    }

    /**
     * Edit lesson
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function editLesson($id): array
    {
        return [
            "id" => "required|integer|exists:lesson_progressions",
        ];
    }

    /**
     * Show lesson
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function showLesson($id): array
    {
        return [
            "id" => "required|integer|exists:lesson_progressions",
        ];
    }

    /**
     * Lesson approving rules
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "type" => "string", 'lesson_power_point' => "string"])] public static function approveSubmission(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "type" => "required|string",
            'lesson_power_point' => 'required|file',
        ];
    }

    /**
     * Lesson rejection rules
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "reason" => "string"])] public static function rejectSubmission(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "reason" => "required|string",
        ];
    }

    /**
     * Approve validated lesson
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "reason" => "string"])] public static function approveRejectLesson(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "reason" => "sometimes|string",
        ];
    }
}
