<?php

namespace App\RequestRules\Api;

use JetBrains\PhpStorm\ArrayShape;

class ClassRules
{
    /**
     * education type rule
     *
     * @return array
     */

    #[ArrayShape(["sub_system_id" => "string"])] public static function getEducationTypes(): array
    {
        return  [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
        ];
    }

    /**
     * Get sub education type rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getSubEducationTypes(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }

    /**
     * Get Level rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getLevels(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }

    /**
     * Get level classes rule
     *
     * @return array
     */
    #[ArrayShape(["level_id" => "string"])] public static function getLevelClasses(): array
    {
        return [
            "level_id" => "required|integer|exists:levels,id",
        ];
    }

    /**
     * Get specialty rule
     *
     * @return array
     */
    #[ArrayShape(["sub_education_type_id" => "string"])] public static function getSpecialties(): array
    {
        return [
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
        ];
    }

    /**
     * Get specialty classes rule
     *
     * @return array
     */
    #[ArrayShape(["specialty_id" => "string"])] public static function getSpecialtyClasses(): array
    {
        return [
            "specialty_id" => "required|integer|exists:specialties,id",
        ];
    }

    /**
     * Get class rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getClasses(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }
}
