<?php

namespace App\Models;

use App\Services\ProgramCoverageService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProgramCoverage extends Model
{
    use HasFactory;
    use SoftDeletes;
    use ProgramCoverageService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'program_coverages';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'school',
        'school_id',
        'inspector_name',
        'inspector_user_id',
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'specialty_id',
        'level_id',
        'class_id',
        'subject_id',

        'number_of_lessons_programmed',
        'number_of_lessons_done',
        'percentage_number_of_lessons_done',
        'comment_number_of_lessons_done',

        'number_of_teaching_hours',
        'number_of_hours_taught',
        'percentage_number_of_hours_taught',
        'comment_number_of_hours_taught',

        'number_of_lessons_to_digitalised',
        'number_of_lessons_digitalised',
        'percentage_number_of_lessons_digitalised',
        'comment_number_of_lessons_digitalised',

        'ots_effective',
        'number_of_ots_participants',
        'number_of_seminars_organised',
        'number_of_seminar_participants',
        ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * The divisions that belong to the region.
     */
}
