<?php

namespace App\Models;

use App\Services\LessonProgressionDetailsService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonProgressionDetail extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LessonProgressionDetailsService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'lesson_progression_details';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'stage',
        'status',

        'lesson_progression_id',
        'submitted_by',
        'submitted_at',
        'submitter_phone_number',

        'submission_validated_by',
        'submission_validated_at',
        'submission_rejected_by',
        'submission_rejected_at',
        'submission_rejection_reason',

        'validation_rejected_by',
        'validation_rejected_at',
        'validation_rejection_reason',

        'recorded_by',
        'recorded_at',
        'recording_rejected_by',
        'recording_rejected_at',
        'recording_rejection_reason',

        'edited_by',
        'edited_at',
        'editing_rejected_by',
        'editing_rejected_at',
        'editing_rejection_reason',

        'segmented_by',
        'segmented_at',
        'segmentation_rejected_by',
        'segmentation_rejected_at',
        'segmentation_rejection_reason',

        'put_in_class_by',
        'put_in_class_at',
        'put_in_class_rejected_by',
        'put_in_class_rejected_at',
        'put_in_class_rejection_reason',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['submitted_at',
        'validated_at',
        'validation_rejected_at',
        'recorded_at',
        'recording_rejected_at',
        'edited_at',
        'editing_rejected_at',
        'segmented_at',
        'segmenting_rejected_at',
        'put_in_classes_at',
        'put_in_classes_rejected_at',
        'created_at',
        'updated_at',
        'deleted_at'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        "lesson_progression_id",
        "submitted_by",
        'validated_by',
        'validation_rejected_by',
        'recorded_by',
        'recording_rejected_by',
        'edited_by',
        'editing_rejected_by',
        'segmented_by',
        'segmenting_rejected_by',
        'put_in_classes_by',
        'put_in_classes_rejected_by',
    ];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */
    public function submittedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "submitted_by");
    }

    public function submissionValidatedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "submission_validated_by");
    }

    public function submissionRejectedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "submission_rejected_by");
    }

    public function validationRejectedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "validation_rejected_by");
    }

    public function recordedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "recorded_by");
    }

    public function recordingRejectedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "recording_rejected_by");
    }

    public function editedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "edited_by");
    }

    public function editingRejectedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "editing_rejected_by");
    }

    public function segmentedBy (): BelongsTo
    {
        return $this->belongsTo(User::class, "segmented_by");
    }

    public function segmentationRejectedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "segmentation_rejected_by");
    }

    public function putInClassBy(): BelongsTo
    {
        return $this->belongsTo(User::class, "put_in_class_by");
    }

    public function putInClassesRejectedBby(): BelongsTo
    {
        return $this->belongsTo(User::class, "put_in_class_rejected_by");
    }
}
