<?php

namespace App\Models;

use App\Services\LessonProgressionService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonProgression extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LessonProgressionService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'lesson_progressions';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'inspectorate_id',
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'level_id',
        'specialty_id',
        'class_id',
        'subject_id',
        'lesson_title_id',
        'type',
        'path',
        'status',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        "inspectorate_id",
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'class_id',
        'subject_id',
        'lesson_title_id',
    ];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * Get inspectorate
     *
     * @return BelongsTo
     */
    public function inspectorate(): BelongsTo
    {
        return $this->belongsTo(Inspectorate::class, "inspectorate_id");
    }

    /**
     * Get sub system relation
     *
     * @return BelongsTo
     */
    public  function subSystem(): BelongsTo
    {
        return $this->belongsTo(SubSystem::class,'sub_system_id');
    }

    /**
     * Get education type relation
     *
     * @return BelongsTo
     */
    public function educationType(): BelongsTo
    {
        return $this->belongsTo(EducationType::class, 'education_type_id');
    }

    /**
     * Get class relation
     *
     * @return BelongsTo
     */
    public function className(): BelongsTo
    {
        return $this->belongsTo(Classes::class,'class_id');
    }

    /**
     * Get subject relation
     *
     * @return BelongsTo
     */
    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    /**
     * Get lesson title relation
     *
     * @return BelongsTo
     */
    public function lessonTitle(): BelongsTo
    {
        return $this->belongsTo(LessonTitle::class, "lesson_title_id");
    }

    /**
     * Get lesson progression details relation
     *
     * @return HasMany
     */
    public function lessonProgressionDetails(): HasMany
    {
        return $this->hasMany(LessonProgressionDetail::class, "lesson_progression_id");
    }
}
