<?php

namespace App\Models;

use App\Services\LessonService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LessonService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'lessons';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['lesson_title_id', 'sub_system_id', 'education_type_id', 'sub_education_type_id', 'level_id', 'specialty_id', 'class_id', 'inspectorate_id', 'subject_id', 'term_id', 'upload_type', 'description', 'duration', 'type', 'path', 'thumbnail', 'converted_for_streaming_at'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['converted_for_streaming_at', 'created_at', 'updated_at', 'deleted_at'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'lesson_title_id',
        'sub_system_id',
        'education_type_id',
        'class_id',
        'subject_id',
        'term_id'
    ];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * Get sub system relation
     *
     * @return BelongsTo
     */
    public  function subSystem(): BelongsTo
    {
        return $this->belongsTo(SubSystem::class,'sub_system_id');
    }

    /**
     * Get education type relation
     *
     * @return BelongsTo
     */
    public function educationType(): BelongsTo
    {
        return $this->belongsTo(EducationType::class, 'education_type_id');
    }

    /**
     * Get class relation
     *
     * @return BelongsTo
     */
    public function className(): BelongsTo
    {
        return $this->belongsTo(Classes::class,'class_id');
    }

    /**
     * Get subject relation
     *
     * @return BelongsTo
     */
    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    /**
     * Get term relation
     *
     * @return BelongsTo
     */
    public function term(): BelongsTo
    {
        return $this->belongsTo(Term::class, 'term_id');
    }

    /**
     * Get Lesson title relation
     *
     * @return BelongsTo
     */
    public function lessonTitle(): BelongsTo
    {
        return $this->belongsTo(LessonTitle::class, 'lesson_title_id');
    }
}
