<?php

namespace App\Imports;

use App\Enums\ResourceUploadTypeEnum;
use App\Models\Lesson;
use App\Models\LessonTitle;
use App\Models\Subject;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class GeneralEducationLessonsImport implements ToCollection, WithHeadingRow
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $collection)
    {
        //Get subject inspectorate
        $subjectInspectorateId = Subject::getSubjectInspectorateId(session('subject_id'));

        $getSubjectLessons = LessonTitle::getGeneralEducationSubjectLessonTitles(session('sub_system_id'), session('education_type_id'), session('class_id'), session('subject_id'));

        $getSubjectLessonArray = array();
        foreach ($getSubjectLessons as $getSubjectLesson) {
            $getSubjectLessonArray[] = array(
                "id" => $getSubjectLesson->{"id"},
                "title" => $getSubjectLesson->{"title"},
            );
        }

        foreach ($collection as $index => $row)   {
            if(strcmp($row["title"], $getSubjectLessonArray[$index]["title"]) == 0) {
                Lesson::store([
                    'lesson_title_id' => $getSubjectLessonArray[$index]["id"],
                    'sub_system_id' => session('sub_system_id'),
                    'education_type_id' => session('education_type_id'),
                    'class_id' => session('class_id'),
                    'subject_id' => session('subject_id'),
                    'inspectorate_id' => $subjectInspectorateId,
                    'term_id' => session('term_id'),
                    'upload_type' => ResourceUploadTypeEnum::youTube->value,
                    'duration' => "28:34",
                    'type' => session('type'),
                    'path' => $row['link'],
                    'thumbnail' => $row['link'],
                ]);
            }
        }

    }
}
