<?php

namespace App\Http\Controllers\Web\Inspectorate;

use App\Http\Controllers\Controller;
use App\Models\Classes;
use App\Models\EducationType;
use App\Models\Inspectorate;
use App\Models\LessonProgression;
use App\Models\Subject;
use App\Models\SubSystem;
use App\RequestRules\Web\LessonProgressionRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class InspectorateLessonController extends Controller
{
    public function lessons(): View|Factory|Application
    {
        $subSystems = SubSystem::allSubSystems();
        $classes = Classes::allClasses();
        $subjects = Subject::allSubjects();
        $inspectorates = Inspectorate::allInspectorates();
        $lessonProgressions = LessonProgression::allLessonProgression();

        return view("inspectorate.validation.index", compact("subSystems", "classes", "subjects", "lessonProgressions", "inspectorates"));
    }

    /**
     * Add lessons for validation
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function addLesson(Request $request): JsonResponse
    {
        $data = $request->all();

        $educationTypeId = preg_replace("/[^0-9]/", "", $data['education_type_id']);
        $type = EducationType::getEducationType((int)$educationTypeId);

        if ($type != null && $type == config('minesec.education_type.general')) {
            $request->validate(LessonProgressionRules::submitGeneralEducationLesson());
            $response = LessonProgression::submitGeneralEducationLesson($data, $educationTypeId, $type);

            if ($response == null) {
                return response()->json(["error" => __("error.generic_error")]);
            }

            return response()->json(["success" => __("messages.record_successfully_created")]);
        }

        if ($type != null && $type == config('minesec.education_type.technical')) {
            $request->validate(LessonProgressionRules::submitTechnicalEducationLesson());
            $response = LessonProgression::submitTechnicalEducationLesson($data, $educationTypeId, $type);
            if ($response == null) {
                return response()->json(["error" => __("error.generic_error")]);
            }

            return response()->json(["success" => __("messages.record_successfully_created")]);
        }

        if ($type != null && $type == config('minesec.education_type.teacher_training')) {
            $request->validate(LessonProgressionRules::submitTeacherTrainingLesson());
            $response = LessonProgression::submitTeacherTrainingLesson($data, $educationTypeId, $type);

            if ($response == null) {
                return response()->json(["error" => __("error.generic_error")]);
            }

            return response()->json(["success" => __("messages.record_successfully_created")]);
        }

        return response()->json(["error" => __("error.generic_error")]);
    }
}
