<?php

namespace Database\Seeders;

use App\Enums\UserTypeEnum;
use App\Models\User;
use App\Models\UserDetail;
use Illuminate\Database\Seeder;

class UserDetailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       /**
        * Super admin
        */
       $this->command->info('Create Admin User ... ');

       /** @var User $user */
       User::factory()->create([
          'email' => null,
          'telephone' => '+237620317491',
          'user_name' => 'Mezaya',
          'bio' => 'TorryMe Admin',
          'verification_requested_at' => null,
          'verified_at'   => null,
          'declined_at'   => null,
          'blocked_at'   => null,
          'profile_picture' => null,
          'user_type' => UserTypeEnum::admin->value,
          'language_code' => 'en',
          'user_detail_id' => UserDetail::factory()->create([
             'first_name' => "Acha",
             'last_name' => "Stanley",
             'date_of_birth' => '1994-04-24',
          ])->{'id'},
          'country_id' => 1,
       ]);

    }
}
